/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractReplicationStrategy {
    protected static final Logger logger_ = Logger.getLogger(AbstractReplicationStrategy.class);
    private TokenMetadata tokenMetadata_;
    protected final IEndPointSnitch snitch_;

    AbstractReplicationStrategy(TokenMetadata tokenMetadata, IEndPointSnitch snitch) {
        this.tokenMetadata_ = tokenMetadata;
        this.snitch_ = snitch;
    }

    public abstract ArrayList<InetAddress> getNaturalEndpoints(Token var1, TokenMetadata var2, String var3);

    public WriteResponseHandler getWriteResponseHandler(int blockFor, ConsistencyLevel consistency_level, String table) {
        return new WriteResponseHandler(blockFor, table);
    }

    public ArrayList<InetAddress> getNaturalEndpoints(Token token, String table) {
        return this.getNaturalEndpoints(token, this.tokenMetadata_, table);
    }

    public Multimap<InetAddress, InetAddress> getHintedEndpoints(String table, Collection<InetAddress> targets) {
        HashMultimap map = HashMultimap.create((int)targets.size(), (int)1);
        IEndPointSnitch endPointSnitch = DatabaseDescriptor.getEndPointSnitch(table);
        for (InetAddress ep : targets) {
            if (!FailureDetector.instance.isAlive(ep)) continue;
            map.put((Object)ep, (Object)ep);
        }
        if (map.size() == targets.size()) {
            return map;
        }
        InetAddress localAddress = FBUtilities.getLocalAddress();
        for (InetAddress ep : targets) {
            if (map.containsKey((Object)ep)) continue;
            InetAddress destination = map.isEmpty() ? localAddress : endPointSnitch.getSortedListByProximity(localAddress, map.keySet()).get(0);
            map.put((Object)destination, (Object)ep);
        }
        return map;
    }

    public Collection<InetAddress> getWriteEndpoints(Token token, String table, Collection<InetAddress> naturalEndpoints) {
        if (this.tokenMetadata_.getPendingRanges(table).isEmpty()) {
            return naturalEndpoints;
        }
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(naturalEndpoints);
        for (Map.Entry<Range, Collection<InetAddress>> entry : this.tokenMetadata_.getPendingRanges(table).entrySet()) {
            if (!entry.getKey().contains(token)) continue;
            endpoints.addAll(entry.getValue());
        }
        return endpoints;
    }

    public Multimap<InetAddress, Range> getAddressRanges(TokenMetadata metadata, String table) {
        HashMultimap map = HashMultimap.create();
        for (Token token : metadata.sortedTokens()) {
            Range range = metadata.getPrimaryRangeFor(token);
            for (InetAddress ep : this.getNaturalEndpoints(token, metadata, table)) {
                map.put((Object)ep, (Object)range);
            }
        }
        return map;
    }

    public Multimap<Range, InetAddress> getRangeAddresses(TokenMetadata metadata, String table) {
        HashMultimap map = HashMultimap.create();
        for (Token token : metadata.sortedTokens()) {
            Range range = metadata.getPrimaryRangeFor(token);
            for (InetAddress ep : this.getNaturalEndpoints(token, metadata, table)) {
                map.put((Object)range, (Object)ep);
            }
        }
        return map;
    }

    public Multimap<InetAddress, Range> getAddressRanges(String table) {
        return this.getAddressRanges(this.tokenMetadata_, table);
    }

    public Collection<Range> getPendingAddressRanges(TokenMetadata metadata, Token pendingToken, InetAddress pendingAddress, String table) {
        TokenMetadata temp = metadata.cloneOnlyTokenMap();
        temp.updateNormalToken(pendingToken, pendingAddress);
        return this.getAddressRanges(temp, table).get((Object)pendingAddress);
    }
}

