/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cassandra.locator.AbstractEndpointSnitch;
import org.apache.cassandra.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class DatacenterEndPointSnitch
extends AbstractEndpointSnitch {
    private Map<Byte, Map<Byte, String>> ipDC = new HashMap<Byte, Map<Byte, String>>();
    private Map<Byte, Map<Byte, String>> ipRAC = new HashMap<Byte, Map<Byte, String>>();
    private Map<String, Integer> dcRepFactor = new HashMap<String, Integer>();
    private XMLUtils xmlUtils;
    private Map<String, Integer> quorumDCMap = new HashMap<String, Integer>();
    private static String DEFAULT_RACK_CONFIG_FILE = "/etc/cassandra/DC-Config.xml";
    private static Logger logger_ = Logger.getLogger(DatacenterEndPointSnitch.class);

    public DatacenterEndPointSnitch() throws IOException, ParserConfigurationException, SAXException {
        this.xmlUtils = new XMLUtils(DEFAULT_RACK_CONFIG_FILE);
        this.reloadConfiguration();
    }

    public String getRackForEndPoint(InetAddress endPoint) throws UnknownHostException {
        byte[] ipQuads = this.getIPAddress(endPoint.getHostAddress());
        return this.ipRAC.get(ipQuads[1]).get(ipQuads[2]);
    }

    public void reloadConfiguration() throws IOException {
        try {
            String[] dcNames;
            for (String dcName : dcNames = this.xmlUtils.getNodeValues("/EndPoints/DataCenter/name")) {
                Map<Byte, String> rackDcMap;
                String dcXPath = "/EndPoints/DataCenter[name='" + dcName + "']";
                String dcIPQuad = this.xmlUtils.getNodeValue(dcXPath + "/ip2ndQuad");
                String replicationFactor = this.xmlUtils.getNodeValue(dcXPath + "/replicationFactor");
                byte dcByte = DatacenterEndPointSnitch.intToByte(Integer.parseInt(dcIPQuad));
                int dcReF = Integer.parseInt(replicationFactor);
                this.dcRepFactor.put(dcName, dcReF);
                this.quorumDCMap.put(dcName, dcReF / 2 + 1);
                String[] racNames = this.xmlUtils.getNodeValues(dcXPath + "/rack/name");
                Map<Byte, String> dcRackMap = this.ipDC.get(dcByte);
                if (null == dcRackMap) {
                    dcRackMap = new HashMap<Byte, String>();
                }
                if (null == (rackDcMap = this.ipRAC.get(dcByte))) {
                    rackDcMap = new HashMap<Byte, String>();
                }
                for (String racName : racNames) {
                    String racIPQuad = this.xmlUtils.getNodeValue(dcXPath + "/rack[name = '" + racName + "']/ip3rdQuad");
                    byte racByte = DatacenterEndPointSnitch.intToByte(Integer.parseInt(racIPQuad));
                    dcRackMap.put(racByte, dcName);
                    rackDcMap.put(racByte, racName);
                }
                this.ipDC.put(dcByte, dcRackMap);
                this.ipRAC.put(dcByte, rackDcMap);
            }
        }
        catch (Exception ioe) {
            throw new IOException("Could not process " + DEFAULT_RACK_CONFIG_FILE, ioe);
        }
    }

    @Override
    public boolean isOnSameRack(InetAddress host, InetAddress host2) throws UnknownHostException {
        byte[] ip = this.getIPAddress(host.getHostAddress());
        byte[] ip2 = this.getIPAddress(host2.getHostAddress());
        return this.ipRAC.get(ip[1]).get(ip[2]).equals(this.ipRAC.get(ip2[1]).get(ip2[2]));
    }

    @Override
    public boolean isInSameDataCenter(InetAddress host, InetAddress host2) throws UnknownHostException {
        byte[] ip = this.getIPAddress(host.getHostAddress());
        byte[] ip2 = this.getIPAddress(host2.getHostAddress());
        return this.ipDC.get(ip[1]).get(ip[2]).equals(this.ipDC.get(ip2[1]).get(ip2[2]));
    }

    public HashMap<String, Integer> getMapReplicationFactor() {
        return new HashMap<String, Integer>(this.dcRepFactor);
    }

    public HashMap<String, Integer> getMapQuorumFactor() {
        return new HashMap<String, Integer>(this.quorumDCMap);
    }

    private byte[] getIPAddress(String host) throws UnknownHostException {
        InetAddress ia = InetAddress.getByName(host);
        return ia.getAddress();
    }

    public static byte intToByte(int n) {
        return (byte)(n & 0xFF);
    }

    @Override
    public String getLocation(InetAddress endpoint) throws UnknownHostException {
        byte[] ipQuads = this.getIPAddress(endpoint.getHostAddress());
        return this.ipDC.get(ipQuads[1]).get(ipQuads[2]);
    }
}

