/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.DatacenterEndPointSnitch;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.DatacenterSyncWriteResponseHandler;
import org.apache.cassandra.service.DatacenterWriteResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;

public class DatacenterShardStategy
extends AbstractReplicationStrategy {
    private static Map<String, List<Token>> dcMap = new HashMap<String, List<Token>>();
    private static Map<String, Integer> dcReplicationFactor = new HashMap<String, Integer>();
    private static Map<String, Integer> quorumRepFactor = new HashMap<String, Integer>();
    private static int locQFactor = 0;
    ArrayList<Token> tokens;
    private List<InetAddress> localEndPoints = new ArrayList<InetAddress>();

    private List<InetAddress> getLocalEndPoints() {
        return new ArrayList<InetAddress>(this.localEndPoints);
    }

    private Map<String, Integer> getQuorumRepFactor() {
        return new HashMap<String, Integer>(quorumRepFactor);
    }

    private synchronized void loadEndPoints(TokenMetadata metadata) throws IOException {
        this.tokens = new ArrayList<Token>(metadata.sortedTokens());
        String localDC = ((DatacenterEndPointSnitch)this.snitch_).getLocation(InetAddress.getLocalHost());
        dcMap = new HashMap<String, List<Token>>();
        for (Token token : this.tokens) {
            List<Token> lst;
            InetAddress endPoint = metadata.getEndPoint(token);
            String dataCenter = ((DatacenterEndPointSnitch)this.snitch_).getLocation(endPoint);
            if (dataCenter.equals(localDC)) {
                this.localEndPoints.add(endPoint);
            }
            if ((lst = dcMap.get(dataCenter)) == null) {
                lst = new ArrayList<Token>();
            }
            lst.add(token);
            dcMap.put(dataCenter, lst);
        }
        for (Map.Entry entry : dcMap.entrySet()) {
            List valueList = (List)entry.getValue();
            Collections.sort(valueList);
            dcMap.put((String)entry.getKey(), valueList);
        }
        dcReplicationFactor = ((DatacenterEndPointSnitch)this.snitch_).getMapReplicationFactor();
        for (Map.Entry entry : dcReplicationFactor.entrySet()) {
            String datacenter = (String)entry.getKey();
            int qFactor = (Integer)entry.getValue() / 2 + 1;
            quorumRepFactor.put(datacenter, qFactor);
            if (!datacenter.equals(localDC)) continue;
            locQFactor = qFactor;
        }
    }

    public DatacenterShardStategy(TokenMetadata tokenMetadata, IEndPointSnitch snitch) throws UnknownHostException {
        super(tokenMetadata, snitch);
        if (!(snitch instanceof DatacenterEndPointSnitch)) {
            throw new IllegalArgumentException("DatacenterShardStrategy requires DatacenterEndpointSnitch");
        }
    }

    @Override
    public ArrayList<InetAddress> getNaturalEndpoints(Token token, TokenMetadata metadata, String table) {
        try {
            return this.getNaturalEndpointsInternal(token, metadata);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private ArrayList<InetAddress> getNaturalEndpointsInternal(Token searchToken, TokenMetadata metadata) throws IOException {
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>();
        if (metadata.sortedTokens().size() == 0) {
            return endpoints;
        }
        if (null == this.tokens || this.tokens.size() != metadata.sortedTokens().size()) {
            this.loadEndPoints(metadata);
        }
        for (String dc : dcMap.keySet()) {
            Token t;
            int replicas_ = dcReplicationFactor.get(dc);
            ArrayList<InetAddress> forloopReturn = new ArrayList<InetAddress>(replicas_);
            List<Token> tokens = dcMap.get(dc);
            boolean bOtherRack = false;
            Iterator<Token> iter = TokenMetadata.ringIterator(tokens, searchToken);
            InetAddress primaryHost = metadata.getEndPoint(iter.next());
            forloopReturn.add(primaryHost);
            while (forloopReturn.size() < replicas_ && iter.hasNext()) {
                t = iter.next();
                InetAddress endPointOfInterest = metadata.getEndPoint(t);
                if (forloopReturn.size() < replicas_ - 1) {
                    forloopReturn.add(endPointOfInterest);
                    continue;
                }
                boolean doneDataCenterItr = true;
                if (!bOtherRack && !((DatacenterEndPointSnitch)this.snitch_).isOnSameRack(primaryHost, endPointOfInterest)) {
                    forloopReturn.add(metadata.getEndPoint(t));
                    bOtherRack = true;
                }
                if (!doneDataCenterItr || !bOtherRack) continue;
                break;
            }
            if (forloopReturn.size() < replicas_) {
                iter = TokenMetadata.ringIterator(tokens, searchToken);
                while (forloopReturn.size() < replicas_ && iter.hasNext()) {
                    t = iter.next();
                    if (forloopReturn.contains(metadata.getEndPoint(t))) continue;
                    forloopReturn.add(metadata.getEndPoint(t));
                }
            }
            endpoints.addAll(forloopReturn);
        }
        return endpoints;
    }

    @Override
    public WriteResponseHandler getWriteResponseHandler(int blockFor, ConsistencyLevel consistency_level, String table) {
        if (consistency_level == ConsistencyLevel.DCQUORUM) {
            return new DatacenterWriteResponseHandler(locQFactor, table);
        }
        if (consistency_level == ConsistencyLevel.DCQUORUMSYNC) {
            return new DatacenterSyncWriteResponseHandler(this.getQuorumRepFactor(), table);
        }
        return super.getWriteResponseHandler(blockFor, consistency_level, table);
    }
}

