/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndPointSnitch;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class RackAwareStrategy
extends AbstractReplicationStrategy {
    public RackAwareStrategy(TokenMetadata tokenMetadata, IEndPointSnitch snitch) {
        super(tokenMetadata, snitch);
        if (!(snitch instanceof EndPointSnitch)) {
            throw new IllegalArgumentException("RackAwareStrategy requires EndPointSnitch.");
        }
    }

    @Override
    public ArrayList<InetAddress> getNaturalEndpoints(Token token, TokenMetadata metadata, String table) {
        Token t;
        int replicas = DatabaseDescriptor.getReplicationFactor(table);
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        List<Token> tokens = metadata.sortedTokens();
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token);
        Token primaryToken = iter.next();
        endpoints.add(metadata.getEndPoint(primaryToken));
        boolean bDataCenter = false;
        boolean bOtherRack = false;
        while (endpoints.size() < replicas && iter.hasNext()) {
            try {
                t = iter.next();
                if (!((EndPointSnitch)this.snitch_).isInSameDataCenter(metadata.getEndPoint(primaryToken), metadata.getEndPoint(t))) {
                    if (bDataCenter) continue;
                    endpoints.add(metadata.getEndPoint(t));
                    bDataCenter = true;
                    continue;
                }
                if (((EndPointSnitch)this.snitch_).isOnSameRack(metadata.getEndPoint(primaryToken), metadata.getEndPoint(t)) || !((EndPointSnitch)this.snitch_).isInSameDataCenter(metadata.getEndPoint(primaryToken), metadata.getEndPoint(t)) || bOtherRack) continue;
                endpoints.add(metadata.getEndPoint(t));
                bOtherRack = true;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        if (endpoints.size() < replicas) {
            iter = TokenMetadata.ringIterator(tokens, token);
            while (endpoints.size() < replicas && iter.hasNext()) {
                t = iter.next();
                if (endpoints.contains(metadata.getEndPoint(t))) continue;
                endpoints.add(metadata.getEndPoint(t));
            }
        }
        return endpoints;
    }
}

