/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;

public class RackUnawareStrategy
extends AbstractReplicationStrategy {
    public RackUnawareStrategy(TokenMetadata tokenMetadata, IEndPointSnitch snitch) {
        super(tokenMetadata, snitch);
    }

    @Override
    public ArrayList<InetAddress> getNaturalEndpoints(Token token, TokenMetadata metadata, String table) {
        int replicas = DatabaseDescriptor.getReplicationFactor(table);
        List<Token> tokens = metadata.sortedTokens();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token);
        while (endpoints.size() < replicas && iter.hasNext()) {
            endpoints.add(metadata.getEndPoint(iter.next()));
        }
        return endpoints;
    }
}

