/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.commons.lang.StringUtils;

public class TokenMetadata {
    private BiMap<Token, InetAddress> tokenToEndPointMap;
    private BiMap<Token, InetAddress> bootstrapTokens;
    private Set<InetAddress> leavingEndPoints;
    private ConcurrentMap<String, Multimap<Range, InetAddress>> pendingRanges;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private List<Token> sortedTokens;

    public TokenMetadata() {
        this(null);
    }

    public TokenMetadata(BiMap<Token, InetAddress> tokenToEndPointMap) {
        if (tokenToEndPointMap == null) {
            tokenToEndPointMap = HashBiMap.create();
        }
        this.tokenToEndPointMap = tokenToEndPointMap;
        this.bootstrapTokens = HashBiMap.create();
        this.leavingEndPoints = new HashSet<InetAddress>();
        this.pendingRanges = new ConcurrentHashMap<String, Multimap<Range, InetAddress>>();
        this.sortedTokens = this.sortTokens();
    }

    private List<Token> sortTokens() {
        ArrayList tokens = new ArrayList(this.tokenToEndPointMap.keySet());
        Collections.sort(tokens);
        return Collections.unmodifiableList(tokens);
    }

    public int pendingRangeChanges(InetAddress source) {
        int n = 0;
        Range sourceRange = this.getPrimaryRangeFor(this.getToken(source));
        for (Token token : this.bootstrapTokens.keySet()) {
            if (!sourceRange.contains(token)) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNormalToken(Token token, InetAddress endpoint) {
        assert (token != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.inverse().remove((Object)endpoint);
            this.tokenToEndPointMap.inverse().remove((Object)endpoint);
            if (!endpoint.equals(this.tokenToEndPointMap.put((Object)token, (Object)endpoint))) {
                this.sortedTokens = this.sortTokens();
            }
            this.leavingEndPoints.remove(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBootstrapToken(Token token, InetAddress endpoint) {
        assert (token != null);
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            InetAddress oldEndPoint = null;
            oldEndPoint = (InetAddress)this.bootstrapTokens.get((Object)token);
            if (oldEndPoint != null && !oldEndPoint.equals(endpoint)) {
                throw new RuntimeException("Bootstrap Token collision between " + oldEndPoint + " and " + endpoint + " (token " + token);
            }
            oldEndPoint = (InetAddress)this.tokenToEndPointMap.get((Object)token);
            if (oldEndPoint != null && !oldEndPoint.equals(endpoint)) {
                throw new RuntimeException("Bootstrap Token collision between " + oldEndPoint + " and " + endpoint + " (token " + token);
            }
            this.bootstrapTokens.inverse().remove((Object)endpoint);
            this.bootstrapTokens.put((Object)token, (Object)endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBootstrapToken(Token token) {
        assert (token != null);
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.remove((Object)token);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeavingEndPoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.leavingEndPoints.add(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLeavingEndPoint(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.writeLock().lock();
        try {
            this.leavingEndPoints.remove(endpoint);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndpoint(InetAddress endpoint) {
        assert (this.tokenToEndPointMap.containsValue((Object)endpoint));
        this.lock.writeLock().lock();
        try {
            this.bootstrapTokens.inverse().remove((Object)endpoint);
            this.tokenToEndPointMap.inverse().remove((Object)endpoint);
            this.leavingEndPoints.remove(endpoint);
            this.sortedTokens = this.sortTokens();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken(InetAddress endpoint) {
        assert (endpoint != null);
        assert (this.isMember(endpoint));
        this.lock.readLock().lock();
        try {
            Token token = (Token)this.tokenToEndPointMap.inverse().get((Object)endpoint);
            return token;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMember(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.tokenToEndPointMap.inverse().containsKey((Object)endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLeaving(InetAddress endpoint) {
        assert (endpoint != null);
        this.lock.readLock().lock();
        try {
            boolean bl = this.leavingEndPoints.contains(endpoint);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getFirstEndpoint() {
        assert (this.tokenToEndPointMap.size() > 0);
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = (InetAddress)this.tokenToEndPointMap.get((Object)this.sortedTokens.get(0));
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneOnlyTokenMap() {
        this.lock.readLock().lock();
        try {
            TokenMetadata tokenMetadata = new TokenMetadata((BiMap<Token, InetAddress>)HashBiMap.create(this.tokenToEndPointMap));
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenMetadata cloneAfterAllLeft() {
        this.lock.readLock().lock();
        try {
            TokenMetadata allLeftMetadata = this.cloneOnlyTokenMap();
            for (InetAddress endPoint : this.leavingEndPoints) {
                allLeftMetadata.removeEndpoint(endPoint);
            }
            TokenMetadata tokenMetadata = allLeftMetadata;
            return tokenMetadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getEndPoint(Token token) {
        this.lock.readLock().lock();
        try {
            InetAddress inetAddress = (InetAddress)this.tokenToEndPointMap.get((Object)token);
            return inetAddress;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Range getPrimaryRangeFor(Token right) {
        return new Range(this.getPredecessor(right), right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> sortedTokens() {
        this.lock.readLock().lock();
        try {
            List<Token> list = this.sortedTokens;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private synchronized Multimap<Range, InetAddress> getPendingRangesMM(String table) {
        Multimap map = (Multimap)this.pendingRanges.get(table);
        if (map == null) {
            map = HashMultimap.create();
            this.pendingRanges.put(table, (Multimap<Range, InetAddress>)map);
        }
        return map;
    }

    public Map<Range, Collection<InetAddress>> getPendingRanges(String table) {
        return this.getPendingRangesMM(table).asMap();
    }

    public List<Range> getPendingRanges(String table, InetAddress endpoint) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Map.Entry entry : this.getPendingRangesMM(table).entries()) {
            if (!((InetAddress)entry.getValue()).equals(endpoint)) continue;
            ranges.add((Range)entry.getKey());
        }
        return ranges;
    }

    public void setPendingRanges(String table, Multimap<Range, InetAddress> rangeMap) {
        this.pendingRanges.put(table, rangeMap);
    }

    public Token getPredecessor(Token token) {
        List<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + StringUtils.join((Collection)this.tokenToEndPointMap.keySet(), (String)", ");
        return index == 0 ? tokens.get(tokens.size() - 1) : tokens.get(index - 1);
    }

    public Token getSuccessor(Token token) {
        List<Token> tokens = this.sortedTokens();
        int index = Collections.binarySearch(tokens, token);
        assert (index >= 0) : token + " not found in " + StringUtils.join((Collection)this.tokenToEndPointMap.keySet(), (String)", ");
        return index == tokens.size() - 1 ? tokens.get(0) : tokens.get(index + 1);
    }

    public InetAddress getSuccessor(InetAddress endPoint) {
        return this.getEndPoint(this.getSuccessor(this.getToken(endPoint)));
    }

    public Map<Token, InetAddress> getBootstrapTokens() {
        return this.bootstrapTokens;
    }

    public Set<InetAddress> getLeavingEndPoints() {
        return this.leavingEndPoints;
    }

    public static Iterator<Token> ringIterator(final List ring, Token start) {
        assert (ring.size() > 0);
        int i = Collections.binarySearch(ring, start);
        if (i < 0 && (i = (i + 1) * -1) >= ring.size()) {
            i = 0;
        }
        final int startIndex = i;
        return new AbstractIterator<Token>(){
            int j;
            {
                this.j = startIndex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Token computeNext() {
                if (this.j < 0) {
                    return (Token)this.endOfData();
                }
                try {
                    Token token = (Token)ring.get(this.j);
                    return token;
                }
                finally {
                    this.j = (this.j + 1) % ring.size();
                    if (this.j == startIndex) {
                        this.j = -1;
                    }
                }
            }
        };
    }

    public void clearUnsafe() {
        this.bootstrapTokens.clear();
        this.tokenToEndPointMap.clear();
        this.leavingEndPoints.clear();
        this.pendingRanges.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lock.readLock().lock();
        try {
            Set eps = this.tokenToEndPointMap.inverse().keySet();
            if (!eps.isEmpty()) {
                sb.append("Normal Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress ep : eps) {
                    sb.append(ep);
                    sb.append(":");
                    sb.append(this.tokenToEndPointMap.inverse().get((Object)ep));
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.bootstrapTokens.isEmpty()) {
                sb.append("Bootstrapping Tokens:");
                sb.append(System.getProperty("line.separator"));
                for (Map.Entry entry : this.bootstrapTokens.entrySet()) {
                    sb.append(entry.getValue() + ":" + entry.getKey());
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.leavingEndPoints.isEmpty()) {
                sb.append("Leaving EndPoints:");
                sb.append(System.getProperty("line.separator"));
                for (InetAddress ep : this.leavingEndPoints) {
                    sb.append(ep);
                    sb.append(System.getProperty("line.separator"));
                }
            }
            if (!this.pendingRanges.isEmpty()) {
                sb.append("Pending Ranges:");
                sb.append(System.getProperty("line.separator"));
                sb.append(this.printPendingRanges());
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return sb.toString();
    }

    public String printPendingRanges() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.pendingRanges.entrySet()) {
            for (Map.Entry rmap : ((Multimap)entry.getValue()).entries()) {
                sb.append(rmap.getValue() + ":" + rmap.getKey());
                sb.append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }
}

