/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.StreamOutManager;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.log4j.Logger;

public class FileStreamTask
extends WrappedRunnable {
    private static Logger logger = Logger.getLogger(FileStreamTask.class);
    public static final int CHUNK_SIZE = 0x2000000;
    private final String file;
    private final long startPosition;
    private final long endPosition;
    private final InetAddress to;

    FileStreamTask(String file, long startPosition, long endPosition, InetAddress from, InetAddress to) {
        this.file = file;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.to = to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runMayThrow() throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.socket().bind(new InetSocketAddress(FBUtilities.getLocalAddress(), 0));
        channel.connect(new InetSocketAddress(this.to, DatabaseDescriptor.getStoragePort()));
        try {
            this.stream(channel);
        }
        finally {
            block9: {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.debug((Object)"error closing socket", (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Done streaming " + this.file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stream(SocketChannel channel) throws IOException {
        long start = this.startPosition;
        RandomAccessFile raf = new RandomAccessFile(new File(this.file), "r");
        try {
            FileChannel fc = raf.getChannel();
            ByteBuffer buffer = MessagingService.constructStreamHeader(false);
            channel.write(buffer);
            assert (buffer.remaining() == 0);
            while (start < this.endPosition) {
                long bytesTransferred = fc.transferTo(start, 0x2000000L, channel);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Bytes transferred " + bytesTransferred));
                }
                StreamOutManager.get(this.to).update(this.file, start += bytesTransferred);
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

