/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.HeaderSerializer;
import org.apache.cassandra.service.StorageService;

public class Header {
    private static ICompactSerializer<Header> serializer_;
    private static AtomicInteger idGen_;
    private InetAddress from_;
    private String type_;
    private StorageService.Verb verb_;
    private String messageId_;
    protected Map<String, byte[]> details_ = new Hashtable<String, byte[]>();

    static ICompactSerializer<Header> serializer() {
        return serializer_;
    }

    Header(String id, InetAddress from, String messageType, StorageService.Verb verb) {
        assert (id != null);
        assert (from != null);
        assert (messageType != null);
        assert (verb != null);
        this.messageId_ = id;
        this.from_ = from;
        this.type_ = messageType;
        this.verb_ = verb;
    }

    Header(String id, InetAddress from, String messageType, StorageService.Verb verb, Map<String, byte[]> details) {
        this(id, from, messageType, verb);
        this.details_ = details;
    }

    Header(InetAddress from, String messageType, StorageService.Verb verb) {
        this(Integer.toString(idGen_.incrementAndGet()), from, messageType, verb);
    }

    InetAddress getFrom() {
        return this.from_;
    }

    String getMessageType() {
        return this.type_;
    }

    StorageService.Verb getVerb() {
        return this.verb_;
    }

    String getMessageId() {
        return this.messageId_;
    }

    void setMessageId(String id) {
        this.messageId_ = id;
    }

    byte[] getDetail(Object key) {
        return this.details_.get(key);
    }

    void setDetail(String key, byte[] value) {
        this.details_.put(key, value);
    }

    static {
        idGen_ = new AtomicInteger(0);
        serializer_ = new HeaderSerializer();
    }
}

