/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.net.Socket;
import org.apache.cassandra.net.MessageDeserializationTask;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.IncomingStreamReader;
import org.apache.log4j.Logger;

public class IncomingTcpConnection
extends Thread {
    private static Logger logger = Logger.getLogger(IncomingTcpConnection.class);
    private final DataInputStream input;
    private Socket socket;

    public IncomingTcpConnection(Socket socket) {
        this.socket = socket;
        try {
            this.input = new DataInputStream(socket.getInputStream());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void run() {
        block5: {
            try {
                while (true) {
                    MessagingService.validateMagic(this.input.readInt());
                    int header = this.input.readInt();
                    int type = MessagingService.getBits(header, 1, 2);
                    boolean isStream = MessagingService.getBits(header, 3, 1) == 1;
                    int version = MessagingService.getBits(header, 15, 8);
                    if (isStream) {
                        new IncomingStreamReader(this.socket.getChannel()).read();
                        continue;
                    }
                    int size = this.input.readInt();
                    byte[] contentBytes = new byte[size];
                    this.input.readFully(contentBytes);
                    MessagingService.getDeserializationExecutor().submit(new MessageDeserializationTask(new ByteArrayInputStream(contentBytes)));
                }
            }
            catch (EOFException e) {
                if (!logger.isTraceEnabled()) break block5;
                logger.trace((Object)"eof reading from socket; closing", (Throwable)e);
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)"error reading from socket; closing", (Throwable)e);
            }
        }
    }
}

