/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.net.Message;

class MessageSerializer
implements ICompactSerializer<Message> {
    MessageSerializer() {
    }

    @Override
    public void serialize(Message t, DataOutputStream dos) throws IOException {
        Header.serializer().serialize(t.header_, dos);
        byte[] bytes = t.getMessageBody();
        dos.writeInt(bytes.length);
        dos.write(bytes);
    }

    @Override
    public Message deserialize(DataInputStream dis) throws IOException {
        Header header = Header.serializer().deserialize(dis);
        int size = dis.readInt();
        byte[] bytes = new byte[size];
        dis.readFully(bytes);
        return new Message(header, bytes);
    }
}

