/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class OutboundTcpConnection
extends Thread {
    private static final Logger logger = Logger.getLogger(OutboundTcpConnection.class);
    private static final ByteBuffer CLOSE_SENTINEL = ByteBuffer.allocate(0);
    private static final int OPEN_RETRY_DELAY = 100;
    private final OutboundTcpConnectionPool pool;
    private final InetAddress endpoint;
    private final BlockingQueue<ByteBuffer> queue = new LinkedBlockingQueue<ByteBuffer>();
    private DataOutputStream output;
    private Socket socket;

    public OutboundTcpConnection(OutboundTcpConnectionPool pool, InetAddress remoteEp) {
        super("WRITE-" + remoteEp);
        this.pool = pool;
        this.endpoint = remoteEp;
    }

    public void write(ByteBuffer buffer) {
        try {
            this.queue.put(buffer);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void closeSocket() {
        this.queue.clear();
        this.write(CLOSE_SENTINEL);
    }

    @Override
    public void run() {
        while (true) {
            ByteBuffer bb;
            if ((bb = this.take()) == CLOSE_SENTINEL) {
                this.disconnect();
                continue;
            }
            if (this.socket == null && !this.connect()) continue;
            this.writeConnected(bb);
        }
    }

    private void writeConnected(ByteBuffer bb) {
        try {
            this.output.write(bb.array(), 0, bb.limit());
            if (this.queue.peek() == null) {
                this.output.flush();
            }
        }
        catch (IOException e) {
            logger.info((Object)("error writing to " + this.endpoint));
            this.disconnect();
        }
    }

    private void disconnect() {
        if (this.socket != null) {
            block3: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)("exception closing connection to " + this.endpoint), (Throwable)e);
                }
            }
            this.output = null;
            this.socket = null;
        }
    }

    private ByteBuffer take() {
        ByteBuffer bb;
        try {
            bb = this.queue.take();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return bb;
    }

    private boolean connect() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("attempting to connect to " + this.endpoint));
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + DatabaseDescriptor.getRpcTimeout()) {
            try {
                this.socket = new Socket(this.endpoint, DatabaseDescriptor.getStoragePort(), FBUtilities.getLocalAddress(), 0);
                this.socket.setTcpNoDelay(true);
                this.output = new DataOutputStream(this.socket.getOutputStream());
                return true;
            }
            catch (IOException e) {
                this.socket = null;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("unable to connect to " + this.endpoint), (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new AssertionError((Object)e1);
                }
            }
        }
        return false;
    }
}

