/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.OutboundTcpConnection;

class OutboundTcpConnectionPool {
    private InetAddress remoteEp_;
    private OutboundTcpConnection cmdCon;
    private OutboundTcpConnection ackCon;

    OutboundTcpConnectionPool(InetAddress remoteEp) {
        this.remoteEp_ = remoteEp;
    }

    synchronized OutboundTcpConnection getConnection(Message msg) {
        if ("RESPONSE-STAGE".equals(msg.getMessageType()) || "GS".equals(msg.getMessageType())) {
            if (this.ackCon == null) {
                this.ackCon = new OutboundTcpConnection(this, this.remoteEp_);
                this.ackCon.start();
            }
            return this.ackCon;
        }
        if (this.cmdCon == null) {
            this.cmdCon = new OutboundTcpConnection(this, this.remoteEp_);
            this.cmdCon.start();
        }
        return this.cmdCon;
    }

    synchronized void reset() {
        for (OutboundTcpConnection con : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            if (con == null) continue;
            con.closeSocket();
        }
    }
}

