/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.DatacenterEndPointSnitch;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.WriteResponseHandler;

public class DatacenterSyncWriteResponseHandler
extends WriteResponseHandler {
    private final Map<String, Integer> dcResponses = new HashMap<String, Integer>();
    private final Map<String, Integer> responseCounts;
    private final DatacenterEndPointSnitch endPointSnitch;

    public DatacenterSyncWriteResponseHandler(Map<String, Integer> responseCounts, String table) {
        super(1, table);
        this.responseCounts = responseCounts;
        this.endPointSnitch = (DatacenterEndPointSnitch)DatabaseDescriptor.getEndPointSnitch(table);
    }

    @Override
    public synchronized void response(Message message) {
        try {
            String dataCenter = this.endPointSnitch.getLocation(message.getFrom());
            Integer blockFor = this.responseCounts.get(dataCenter);
            if (blockFor != null) {
                Integer quorumCount = this.dcResponses.get(dataCenter);
                if (quorumCount == null) {
                    this.dcResponses.put(dataCenter, 1);
                } else if (blockFor > quorumCount) {
                    this.dcResponses.put(dataCenter, quorumCount + 1);
                } else {
                    this.responseCounts.remove(dataCenter);
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.responses.add(message);
        if (this.responseCounts.isEmpty()) {
            this.condition.signal();
        }
    }
}

