/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.DatacenterEndPointSnitch;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.utils.FBUtilities;

public class DatacenterWriteResponseHandler
extends WriteResponseHandler {
    private final AtomicInteger blockFor;
    private final DatacenterEndPointSnitch endpointsnitch;
    private final InetAddress localEndpoint;

    public DatacenterWriteResponseHandler(int blockFor, String table) {
        super(blockFor, table);
        this.blockFor = new AtomicInteger(blockFor);
        this.endpointsnitch = (DatacenterEndPointSnitch)DatabaseDescriptor.getEndPointSnitch(table);
        this.localEndpoint = FBUtilities.getLocalAddress();
    }

    @Override
    public void response(Message message) {
        int b = -1;
        try {
            if (this.endpointsnitch.isInSameDataCenter(this.localEndpoint, message.getFrom())) {
                b = this.blockFor.decrementAndGet();
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.responses.add(message);
        if (b == 0) {
            this.condition.signal();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processed Message: " + message.toString()));
        }
    }
}

