/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class GCInspector {
    public static final GCInspector instance = new GCInspector();
    private static final Logger logger = Logger.getLogger(GCInspector.class);
    static final long INTERVAL_IN_MS = 10000L;
    static final long MIN_DURATION = 200L;
    private HashMap<String, Long> gctimes = new HashMap();
    List<GarbageCollectorMXBean> beans = new ArrayList<GarbageCollectorMXBean>();

    public GCInspector() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            for (ObjectName name : server.queryNames(gcName, null)) {
                GarbageCollectorMXBean gc = ManagementFactory.newPlatformMXBeanProxy(server, name.getCanonicalName(), GarbageCollectorMXBean.class);
                this.beans.add(gc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void start() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                GCInspector.this.logIntervalGCStats();
            }
        };
        new Timer("GC inspection").schedule(t, 10000L, 10000L);
    }

    private void logIntervalGCStats() {
        for (GarbageCollectorMXBean gc : this.beans) {
            Long previous;
            GcInfo gci = gc.getLastGcInfo();
            if (gci == null || (previous = this.gctimes.get(gc.getName())) != null && previous.longValue() == gc.getCollectionTime()) continue;
            this.gctimes.put(gc.getName(), gc.getCollectionTime());
            long previousMemoryUsed = 0L;
            long memoryUsed = 0L;
            long memoryMax = 0L;
            for (Map.Entry<String, MemoryUsage> entry : gci.getMemoryUsageBeforeGc().entrySet()) {
                previousMemoryUsed += entry.getValue().getUsed();
            }
            for (Map.Entry<String, MemoryUsage> entry : gci.getMemoryUsageAfterGc().entrySet()) {
                MemoryUsage mu = entry.getValue();
                memoryUsed += mu.getUsed();
                memoryMax += mu.getMax();
            }
            String st = String.format("GC for %s: %s ms, %s reclaimed leaving %s used; max is %s", gc.getName(), gci.getDuration(), previousMemoryUsed - memoryUsed, memoryUsed, memoryMax);
            if (gci.getDuration() > 200L) {
                logger.info((Object)st);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)st);
        }
    }
}

