/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.log4j.Logger;

public class QuorumResponseHandler<T>
implements IAsyncCallback {
    protected static final Logger logger = Logger.getLogger(QuorumResponseHandler.class);
    protected final SimpleCondition condition = new SimpleCondition();
    protected final Collection<Message> responses = new LinkedBlockingQueue<Message>();
    private IResponseResolver<T> responseResolver;
    private final long startTime;

    public QuorumResponseHandler(int responseCount, IResponseResolver<T> responseResolver) {
        this.responseResolver = responseResolver;
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws TimeoutException, DigestMismatchException, IOException {
        try {
            boolean success;
            long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
            try {
                success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                throw new AssertionError((Object)ex);
            }
            if (!success) {
                StringBuilder sb = new StringBuilder("");
                for (Message message : this.responses) {
                    sb.append(message.getFrom());
                }
                throw new TimeoutException("Operation timed out - received only " + this.responses.size() + " responses from " + sb.toString() + " .");
            }
        }
        finally {
            for (Message response : this.responses) {
                MessagingService.removeRegisteredCallback(response.getMessageId());
            }
        }
        return this.responseResolver.resolve(this.responses);
    }

    @Override
    public void response(Message message) {
        this.responses.add(message);
        if (this.responseResolver.isDataPresent(this.responses)) {
            this.condition.signal();
        }
    }
}

