/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.log4j.Logger;

public class RangeSliceResponseResolver
implements IResponseResolver<List<Row>> {
    private static final Logger logger_ = Logger.getLogger(RangeSliceResponseResolver.class);
    private final String table;
    private final List<InetAddress> sources;

    public RangeSliceResponseResolver(String table, List<InetAddress> sources) {
        assert (sources.size() > 0);
        this.sources = sources;
        this.table = table;
    }

    @Override
    public List<Row> resolve(Collection<Message> responses) throws DigestMismatchException, IOException {
        CollatingIterator collator = new CollatingIterator((Comparator)new Comparator<Pair<Row, InetAddress>>(){

            @Override
            public int compare(Pair<Row, InetAddress> o1, Pair<Row, InetAddress> o2) {
                return ((Row)o1.left).key.compareTo(((Row)o2.left).key);
            }
        });
        int n = 0;
        for (Message response : responses) {
            RangeSliceReply reply = RangeSliceReply.read(response.getMessageBody());
            n = Math.max(n, reply.rows.size());
            collator.addIterator((Iterator)((Object)new RowIterator(reply.rows.iterator(), response.getFrom())));
        }
        ReducingIterator<Pair<Row, InetAddress>, Row> iter = new ReducingIterator<Pair<Row, InetAddress>, Row>((Iterator)collator){
            List<ColumnFamily> versions;
            List<InetAddress> versionSources;
            String key;
            {
                this.versions = new ArrayList<ColumnFamily>(RangeSliceResponseResolver.this.sources.size());
                this.versionSources = new ArrayList<InetAddress>(RangeSliceResponseResolver.this.sources.size());
            }

            @Override
            protected boolean isEqual(Pair<Row, InetAddress> o1, Pair<Row, InetAddress> o2) {
                return ((Row)o1.left).key.equals(((Row)o2.left).key);
            }

            @Override
            public void reduce(Pair<Row, InetAddress> current) {
                this.key = ((Row)current.left).key;
                this.versions.add(((Row)current.left).cf);
                this.versionSources.add((InetAddress)current.right);
            }

            @Override
            protected Row getReduced() {
                ColumnFamily resolved = ReadResponseResolver.resolveSuperset(this.versions);
                ReadResponseResolver.maybeScheduleRepairs(resolved, RangeSliceResponseResolver.this.table, this.key, this.versions, this.versionSources);
                this.versions.clear();
                this.versionSources.clear();
                return new Row(this.key, resolved);
            }
        };
        ArrayList<Row> resolvedRows = new ArrayList<Row>(n);
        while (iter.hasNext()) {
            resolvedRows.add((Row)iter.next());
        }
        return resolvedRows;
    }

    @Override
    public boolean isDataPresent(Collection<Message> responses) {
        return responses.size() >= this.sources.size();
    }

    private static class RowIterator
    extends AbstractIterator<Pair<Row, InetAddress>> {
        private final Iterator<Row> iter;
        private final InetAddress source;

        private RowIterator(Iterator<Row> iter, InetAddress source) {
            this.iter = iter;
            this.source = source;
        }

        protected Pair<Row, InetAddress> computeNext() {
            return this.iter.hasNext() ? new Pair<Row, InetAddress>(this.iter.next(), this.source) : (Pair)this.endOfData();
        }
    }
}

