/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.log4j.Logger;

public class RangeSliceVerbHandler
implements IVerbHandler {
    private static final Logger logger = Logger.getLogger(RangeSliceVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        try {
            RangeSliceCommand command = RangeSliceCommand.read(message);
            ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
            RangeSliceReply reply = cfs.getRangeSlice(command.super_column, command.range, command.max_keys, command.predicate.slice_range, command.predicate.column_names);
            Message response = reply.getReply(message);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending " + reply + " to " + message.getMessageId() + "@" + message.getFrom()));
            }
            MessagingService.instance.sendOneWay(response, message.getFrom());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

