/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.cache.ICacheExpungeHook;
import org.apache.cassandra.db.RowMutationMessage;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ExpiringMap;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

class ReadRepairManager {
    private static final Logger logger_ = Logger.getLogger(ReadRepairManager.class);
    private static final long expirationTimeInMillis = 2000L;
    public static final ReadRepairManager instance = new ReadRepairManager();
    private ExpiringMap<String, Message> readRepairTable_ = new ExpiringMap<String, Message>(2000L, new ReadRepairPerformer());

    protected ReadRepairManager() {
    }

    public void schedule(InetAddress target, RowMutationMessage rowMutationMessage) {
        try {
            Message message = rowMutationMessage.makeRowMutationMessage(StorageService.Verb.READ_REPAIR);
            String key = target.getHostAddress() + ":" + message.getMessageId();
            this.readRepairTable_.put(key, message);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    static class ReadRepairPerformer
    implements ICacheExpungeHook<String, Message> {
        ReadRepairPerformer() {
        }

        @Override
        public void callMe(String target, Message message) {
            String[] pieces = FBUtilities.strip(target, ":");
            InetAddress to = null;
            try {
                to = InetAddress.getByName(pieces[0]);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            MessagingService.instance.sendOneWay(message, to);
        }
    }
}

