/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowMutationMessage;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.ReadRepairManager;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class ReadResponseResolver
implements IResponseResolver<Row> {
    private static Logger logger_ = Logger.getLogger(ReadResponseResolver.class);
    private final String table;
    private final int responseCount;

    public ReadResponseResolver(String table, int responseCount) {
        assert (1 <= responseCount && responseCount <= DatabaseDescriptor.getReplicationFactor(table)) : "invalid response count " + responseCount;
        this.responseCount = responseCount;
        this.table = table;
    }

    @Override
    public Row resolve(Collection<Message> responses) throws DigestMismatchException, IOException {
        long startTime = System.currentTimeMillis();
        ArrayList<ColumnFamily> versions = new ArrayList<ColumnFamily>();
        ArrayList<InetAddress> endPoints = new ArrayList<InetAddress>();
        String key = null;
        byte[] digest = new byte[]{};
        boolean isDigestQuery = false;
        for (Message response : responses) {
            byte[] body = response.getMessageBody();
            ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
            ReadResponse result = ReadResponse.serializer().deserialize(new DataInputStream(bufIn));
            if (result.isDigestQuery()) {
                digest = result.digest();
                isDigestQuery = true;
                continue;
            }
            versions.add(result.row().cf);
            endPoints.add(response.getFrom());
            key = result.row().key;
        }
        if (isDigestQuery) {
            for (ColumnFamily cf : versions) {
                if (Arrays.equals(ColumnFamily.digest(cf), digest)) continue;
                String s = String.format("Mismatch for key %s (%s vs %s)", key, FBUtilities.bytesToHex(ColumnFamily.digest(cf)), FBUtilities.bytesToHex(digest));
                throw new DigestMismatchException(s);
            }
        }
        ColumnFamily resolved = ReadResponseResolver.resolveSuperset(versions);
        ReadResponseResolver.maybeScheduleRepairs(resolved, this.table, key, versions, endPoints);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("resolve: " + (System.currentTimeMillis() - startTime) + " ms."));
        }
        return new Row(key, resolved);
    }

    public static void maybeScheduleRepairs(ColumnFamily resolved, String table, String key, List<ColumnFamily> versions, List<InetAddress> endPoints) {
        for (int i = 0; i < versions.size(); ++i) {
            ColumnFamily diffCf = ColumnFamily.diff(versions.get(i), resolved);
            if (diffCf == null) continue;
            RowMutation rowMutation = new RowMutation(table, key);
            rowMutation.add(diffCf);
            RowMutationMessage rowMutationMessage = new RowMutationMessage(rowMutation);
            ReadRepairManager.instance.schedule(endPoints.get(i), rowMutationMessage);
        }
    }

    static ColumnFamily resolveSuperset(List<ColumnFamily> versions) {
        assert (versions.size() > 0);
        ColumnFamily resolved = null;
        for (ColumnFamily cf : versions) {
            if (cf == null) continue;
            resolved = cf.cloneMe();
            break;
        }
        if (resolved == null) {
            return null;
        }
        for (ColumnFamily cf : versions) {
            resolved.resolve(cf);
        }
        return resolved;
    }

    @Override
    public boolean isDataPresent(Collection<Message> responses) {
        if (responses.size() < this.responseCount) {
            return false;
        }
        boolean isDataPresent = false;
        for (Message response : responses) {
            byte[] body = response.getMessageBody();
            ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
            try {
                ReadResponse result = ReadResponse.serializer().deserialize(new DataInputStream(bufIn));
                if (!result.isDigestQuery()) {
                    isDataPresent = true;
                }
                bufIn.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return isDataPresent;
    }
}

