/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndPointStateChangeSubscriber;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.LoadDisseminator;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;

public class StorageLoadBalancer
implements IEndPointStateChangeSubscriber {
    private static final int BROADCAST_INTERVAL = 60000;
    public static final StorageLoadBalancer instance = new StorageLoadBalancer();
    private static final Logger logger_ = Logger.getLogger(StorageLoadBalancer.class);
    private static final int delay_ = 5;
    private static final double TOPHEAVY_RATIO = 1.5;
    private AtomicBoolean isMoveable_ = new AtomicBoolean(false);
    private Map<InetAddress, Double> loadInfo_ = new HashMap<InetAddress, Double>();
    private Map<InetAddress, Double> loadInfo2_ = new HashMap<InetAddress, Double>();
    private ExecutorService lb_ = new JMXEnabledThreadPoolExecutor("LB-OPERATIONS");
    private ExecutorService lbOperations_ = new JMXEnabledThreadPoolExecutor("LB-TARGET");
    private Timer loadTimer_ = new Timer(false);

    private StorageLoadBalancer() {
        Gossiper.instance.register(this);
    }

    @Override
    public void onChange(InetAddress endpoint, String stateName, ApplicationState state) {
        if (!stateName.equals("LOAD-INFORMATION")) {
            return;
        }
        this.loadInfo_.put(endpoint, Double.parseDouble(state.getValue()));
    }

    @Override
    public void onJoin(InetAddress endpoint, EndPointState epState) {
        ApplicationState loadState = epState.getApplicationState("LOAD-INFORMATION");
        if (loadState != null) {
            this.onChange(endpoint, "LOAD-INFORMATION", loadState);
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndPointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndPointState state) {
    }

    private double localLoad() {
        Double load = this.loadInfo2_.get(FBUtilities.getLocalAddress());
        return load == null ? 0.0 : load;
    }

    private double averageSystemLoad() {
        double averageLoad;
        int nodeCount = this.loadInfo2_.size();
        Set<InetAddress> nodes = this.loadInfo2_.keySet();
        double systemLoad = 0.0;
        for (InetAddress node : nodes) {
            systemLoad += this.loadInfo2_.get(node).doubleValue();
        }
        double d = averageLoad = nodeCount > 0 ? systemLoad / (double)nodeCount : 0.0;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Average system load is " + averageLoad));
        }
        return averageLoad;
    }

    private boolean isHeavyNode() {
        return this.localLoad() > 1.5 * this.averageSystemLoad();
    }

    private boolean isMoveable(InetAddress target) {
        double targetLoad;
        double threshold = 1.5 * this.averageSystemLoad();
        if (this.isANeighbour(target)) {
            Double load = this.loadInfo2_.get(target);
            if (load == null) {
                return false;
            }
            double myload = this.localLoad();
            double avgLoad = (load + myload) / 2.0;
            return avgLoad <= threshold;
        }
        InetAddress successor = StorageService.instance.getSuccessor(target);
        double sLoad = this.loadInfo2_.get(successor);
        return sLoad + (targetLoad = this.loadInfo2_.get(target).doubleValue()) <= threshold;
    }

    private boolean isANeighbour(InetAddress neighbour) {
        InetAddress predecessor = StorageService.instance.getPredecessor(FBUtilities.getLocalAddress());
        if (predecessor.equals(neighbour)) {
            return true;
        }
        InetAddress successor = StorageService.instance.getSuccessor(FBUtilities.getLocalAddress());
        return successor.equals(neighbour);
    }

    private InetAddress findARandomLightNode() {
        ArrayList<InetAddress> potentialCandidates = new ArrayList<InetAddress>();
        Set<InetAddress> allTargets = this.loadInfo2_.keySet();
        double avgLoad = this.averageSystemLoad();
        for (InetAddress target : allTargets) {
            double load = this.loadInfo2_.get(target);
            if (!(load < avgLoad)) continue;
            potentialCandidates.add(target);
        }
        if (potentialCandidates.size() > 0) {
            Random random = new Random();
            int index = random.nextInt(potentialCandidates.size());
            return (InetAddress)potentialCandidates.get(index);
        }
        return null;
    }

    public Map<InetAddress, Double> getLoadInfo() {
        return this.loadInfo_;
    }

    public void startBroadcasting() {
        this.loadTimer_.schedule((TimerTask)new LoadDisseminator(), 2000L, 60000L);
    }

    public void waitForLoadInfo() {
        int duration = 90000;
        try {
            logger_.info((Object)("Sleeping " + duration + " ms to wait for load information..."));
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    class MoveMessageVerbHandler
    implements IVerbHandler {
        MoveMessageVerbHandler() {
        }

        @Override
        public void doVerb(Message message) {
            Message reply = message.getReply(FBUtilities.getLocalAddress(), new byte[]{(byte)(StorageLoadBalancer.this.isMoveable_.get() ? 1 : 0)});
            MessagingService.instance.sendOneWay(reply, message.getFrom());
            if (StorageLoadBalancer.this.isMoveable_.get()) {
                StorageLoadBalancer.this.isMoveable_.set(false);
            }
        }
    }

    class LoadBalancer
    implements Runnable {
        LoadBalancer() {
            StorageLoadBalancer.this.loadInfo2_.putAll(StorageLoadBalancer.this.loadInfo_);
        }

        @Override
        public void run() {
        }
    }
}

