/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Multimap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.QuorumResponseHandler;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StorageProxy
implements StorageProxyMBean {
    private static final Logger logger = Logger.getLogger(StorageProxy.class);
    private static final LatencyTracker readStats = new LatencyTracker();
    private static final LatencyTracker rangeStats = new LatencyTracker();
    private static final LatencyTracker writeStats = new LatencyTracker();
    private static final Comparator<String> keyComparator;

    private StorageProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mutate(List<RowMutation> mutations) {
        long startTime = System.nanoTime();
        try {
            StorageService ss = StorageService.instance;
            for (final RowMutation rm : mutations) {
                try {
                    String table = rm.getTable();
                    AbstractReplicationStrategy rs = ss.getReplicationStrategy(table);
                    List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, rm.key());
                    Multimap<InetAddress, InetAddress> hintedEndpoints = rs.getHintedEndpoints(table, naturalEndpoints);
                    Message unhintedMessage = null;
                    for (Map.Entry entry : hintedEndpoints.asMap().entrySet()) {
                        InetAddress destination = (InetAddress)entry.getKey();
                        Collection targets = (Collection)entry.getValue();
                        if (targets.size() == 1 && ((InetAddress)targets.iterator().next()).equals(destination)) {
                            if (destination.equals(FBUtilities.getLocalAddress())) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("insert writing local key " + rm.key()));
                                }
                                WrappedRunnable runnable = new WrappedRunnable(){

                                    @Override
                                    public void runMayThrow() throws IOException {
                                        rm.apply();
                                    }
                                };
                                StageManager.getStage("ROW-MUTATION-STAGE").execute(runnable);
                                continue;
                            }
                            if (unhintedMessage == null) {
                                unhintedMessage = rm.makeRowMutationMessage();
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("insert writing key " + rm.key() + " to " + unhintedMessage.getMessageId() + "@" + destination));
                            }
                            MessagingService.instance.sendOneWay(unhintedMessage, destination);
                            continue;
                        }
                        Message hintedMessage = rm.makeRowMutationMessage();
                        for (InetAddress target : targets) {
                            if (target.equals(destination)) continue;
                            StorageProxy.addHintHeader(hintedMessage, target);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("insert writing key " + rm.key() + " to " + hintedMessage.getMessageId() + "@" + destination + " for " + target));
                        }
                        MessagingService.instance.sendOneWay(hintedMessage, destination);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("error inserting key " + rm.key(), e);
                    return;
                }
            }
        }
        finally {
            writeStats.addNano(System.nanoTime() - startTime);
        }
    }

    private static void addHintHeader(Message message, InetAddress target) {
        byte[] oldHint = message.getHeader("HINT");
        byte[] hint = oldHint == null ? target.getAddress() : ArrayUtils.addAll((byte[])oldHint, (byte[])target.getAddress());
        message.setHeader("HINT", hint);
    }

    public static void mutateBlocking(List<RowMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, TimeoutException {
        long startTime = System.nanoTime();
        ArrayList<WriteResponseHandler> responseHandlers = new ArrayList<WriteResponseHandler>();
        RowMutation mostRecentRowMutation = null;
        StorageService ss = StorageService.instance;
        try {
            Iterator<RowMutation> i$ = mutations.iterator();
            while (i$.hasNext()) {
                RowMutation rm;
                mostRecentRowMutation = rm = i$.next();
                String table = rm.getTable();
                AbstractReplicationStrategy rs = ss.getReplicationStrategy(table);
                List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, rm.key());
                Collection<InetAddress> writeEndpoints = rs.getWriteEndpoints((Token)StorageService.getPartitioner().getToken(rm.key()), table, (Collection<InetAddress>)naturalEndpoints);
                Multimap<InetAddress, InetAddress> hintedEndpoints = rs.getHintedEndpoints(table, writeEndpoints);
                int blockFor = StorageProxy.determineBlockFor(writeEndpoints.size(), consistency_level);
                StorageProxy.assureSufficientLiveNodes(blockFor, writeEndpoints, hintedEndpoints, consistency_level);
                WriteResponseHandler responseHandler = ss.getWriteResponseHandler(blockFor, consistency_level, table);
                responseHandlers.add(responseHandler);
                Message unhintedMessage = null;
                for (Map.Entry entry : hintedEndpoints.asMap().entrySet()) {
                    InetAddress destination = (InetAddress)entry.getKey();
                    Collection targets = (Collection)entry.getValue();
                    if (targets.size() == 1 && ((InetAddress)targets.iterator().next()).equals(destination)) {
                        if (destination.equals(FBUtilities.getLocalAddress())) {
                            StorageProxy.insertLocalMessage(rm, responseHandler);
                            continue;
                        }
                        if (unhintedMessage == null) {
                            unhintedMessage = rm.makeRowMutationMessage();
                            MessagingService.instance.addCallback(responseHandler, unhintedMessage.getMessageId());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("insert writing key " + rm.key() + " to " + unhintedMessage.getMessageId() + "@" + destination));
                        }
                        MessagingService.instance.sendOneWay(unhintedMessage, destination);
                        continue;
                    }
                    Message hintedMessage = rm.makeRowMutationMessage();
                    for (InetAddress target : targets) {
                        if (target.equals(destination)) continue;
                        StorageProxy.addHintHeader(hintedMessage, target);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("insert writing key " + rm.key() + " to " + hintedMessage.getMessageId() + "@" + destination + " for " + target));
                    }
                    if (writeEndpoints.contains(destination) || consistency_level == ConsistencyLevel.ANY) {
                        MessagingService.instance.addCallback(responseHandler, hintedMessage.getMessageId());
                    }
                    MessagingService.instance.sendOneWay(hintedMessage, destination);
                }
            }
            for (WriteResponseHandler responseHandler : responseHandlers) {
                responseHandler.get();
            }
        }
        catch (IOException e) {
            if (mostRecentRowMutation == null) {
                throw new RuntimeException("no mutations were seen but found an error during write anyway", e);
            }
            throw new RuntimeException("error writing key " + mostRecentRowMutation.key(), e);
        }
        finally {
            writeStats.addNano(System.nanoTime() - startTime);
        }
    }

    private static void assureSufficientLiveNodes(int blockFor, Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel) throws UnavailableException {
        if (consistencyLevel == ConsistencyLevel.ANY && hintedEndpoints.keySet().size() < blockFor) {
            throw new UnavailableException();
        }
        int liveNodes = 0;
        for (InetAddress destination : hintedEndpoints.keySet()) {
            if (!writeEndpoints.contains(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < blockFor) {
            throw new UnavailableException();
        }
    }

    private static void insertLocalMessage(final RowMutation rm, final WriteResponseHandler responseHandler) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("insert writing local key " + rm.key()));
        }
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws IOException {
                rm.apply();
                responseHandler.localResponse();
            }
        };
        StageManager.getStage("ROW-MUTATION-STAGE").execute(runnable);
    }

    private static int determineBlockFor(int expandedTargets, ConsistencyLevel consistency_level) {
        switch (consistency_level) {
            case ONE: 
            case ANY: {
                return 1;
            }
            case QUORUM: {
                return expandedTargets / 2 + 1;
            }
            case DCQUORUM: 
            case DCQUORUMSYNC: {
                return expandedTargets;
            }
            case ALL: {
                return expandedTargets;
            }
        }
        throw new UnsupportedOperationException("invalid consistency level " + (Object)((Object)consistency_level));
    }

    private static List<Row> weakReadRemote(List<ReadCommand> commands) throws IOException, UnavailableException, TimeoutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("weakreadremote reading " + StringUtils.join(commands, (String)", ")));
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<IAsyncResult> iars = new ArrayList<IAsyncResult>();
        for (ReadCommand command : commands) {
            InetAddress endPoint = StorageService.instance.findSuitableEndPoint(command.table, command.key);
            Message message = command.makeReadMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("weakreadremote reading " + command + " from " + message.getMessageId() + "@" + endPoint));
            }
            if (DatabaseDescriptor.getConsistencyCheck()) {
                message.setHeader("READ-REPAIR", "READ-REPAIR".getBytes());
            }
            iars.add(MessagingService.instance.sendRR(message, endPoint));
        }
        for (IAsyncResult iar : iars) {
            byte[] body = iar.get(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
            ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
            ReadResponse response = ReadResponse.serializer().deserialize(new DataInputStream(bufIn));
            if (response.row() == null) continue;
            rows.add(response.row());
        }
        return rows;
    }

    public static List<Row> readProtocol(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        long startTime = System.nanoTime();
        ArrayList<Row> rows = new ArrayList();
        if (consistency_level == ConsistencyLevel.ONE) {
            ArrayList<ReadCommand> localCommands = new ArrayList<ReadCommand>();
            ArrayList<ReadCommand> remoteCommands = new ArrayList<ReadCommand>();
            for (ReadCommand command : commands) {
                List<InetAddress> endpoints = StorageService.instance.getNaturalEndpoints(command.table, command.key);
                boolean foundLocal = endpoints.contains(FBUtilities.getLocalAddress());
                if (foundLocal && !StorageService.instance.isBootstrapMode()) {
                    localCommands.add(command);
                    continue;
                }
                remoteCommands.add(command);
            }
            if (localCommands.size() > 0) {
                rows.addAll(StorageProxy.weakReadLocal(localCommands));
            }
            if (remoteCommands.size() > 0) {
                rows.addAll(StorageProxy.weakReadRemote(remoteCommands));
            }
        } else {
            assert (consistency_level.getValue() >= ConsistencyLevel.QUORUM.getValue());
            rows = StorageProxy.strongRead(commands, consistency_level);
        }
        readStats.addNano(System.nanoTime() - startTime);
        return rows;
    }

    private static List<Row> strongRead(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        ArrayList<QuorumResponseHandler<Row>> quorumResponseHandlers = new ArrayList<QuorumResponseHandler<Row>>();
        ArrayList<InetAddress[]> commandEndPoints = new ArrayList<InetAddress[]>();
        ArrayList<Row> rows = new ArrayList<Row>();
        int commandIndex = 0;
        for (ReadCommand readCommand : commands) {
            assert (!readCommand.isDigestQuery());
            ReadCommand readMessageDigestOnly = readCommand.copy();
            readMessageDigestOnly.setDigestQuery(true);
            Message message = readCommand.makeReadMessage();
            Message messageDigestOnly = readMessageDigestOnly.makeReadMessage();
            InetAddress dataPoint = StorageService.instance.findSuitableEndPoint(readCommand.table, readCommand.key);
            List<InetAddress> endpointList = StorageService.instance.getLiveNaturalEndpoints(readCommand.table, readCommand.key);
            String table = readCommand.table;
            int responseCount = StorageProxy.determineBlockFor(DatabaseDescriptor.getReplicationFactor(table), consistency_level);
            if (endpointList.size() < responseCount) {
                throw new UnavailableException();
            }
            InetAddress[] endPoints = new InetAddress[endpointList.size()];
            Message[] messages = new Message[endpointList.size()];
            int n = 0;
            for (InetAddress endpoint : endpointList) {
                Message m = endpoint.equals(dataPoint) ? message : messageDigestOnly;
                endPoints[n] = endpoint;
                messages[n++] = m;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("strongread reading " + (m == message ? "data" : "digest") + " for " + readCommand + " from " + m.getMessageId() + "@" + endpoint));
            }
            QuorumResponseHandler<Row> quorumResponseHandler = new QuorumResponseHandler<Row>(DatabaseDescriptor.getQuorum(readCommand.table), new ReadResponseResolver(readCommand.table, responseCount));
            MessagingService.instance.sendRR(messages, endPoints, quorumResponseHandler);
            quorumResponseHandlers.add(quorumResponseHandler);
            commandEndPoints.add(endPoints);
        }
        for (QuorumResponseHandler quorumResponseHandler : quorumResponseHandlers) {
            block12: {
                Row row;
                ReadCommand command = commands.get(commandIndex);
                try {
                    long startTime2 = System.currentTimeMillis();
                    row = (Row)quorumResponseHandler.get();
                    if (row != null) {
                        rows.add(row);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("quorumResponseHandler: " + (System.currentTimeMillis() - startTime2) + " ms."));
                    }
                }
                catch (DigestMismatchException ex) {
                    if (!DatabaseDescriptor.getConsistencyCheck()) break block12;
                    ReadResponseResolver readResponseResolverRepair = new ReadResponseResolver(command.table, DatabaseDescriptor.getQuorum(command.table));
                    QuorumResponseHandler<Row> quorumResponseHandlerRepair = new QuorumResponseHandler<Row>(DatabaseDescriptor.getQuorum(command.table), readResponseResolverRepair);
                    logger.info((Object)("DigestMismatchException: " + ex.getMessage()));
                    Message messageRepair = command.makeReadMessage();
                    MessagingService.instance.sendRR(messageRepair, (InetAddress[])commandEndPoints.get(commandIndex), quorumResponseHandlerRepair);
                    try {
                        row = quorumResponseHandlerRepair.get();
                        if (row != null) {
                            rows.add(row);
                        }
                    }
                    catch (DigestMismatchException e) {
                        throw new RuntimeException("digest mismatch reading key " + command.key, e);
                    }
                }
            }
            ++commandIndex;
        }
        return rows;
    }

    private static List<Row> weakReadLocal(List<ReadCommand> commands) {
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (ReadCommand readCommand : commands) {
            weakReadLocalCallable callable = new weakReadLocalCallable(readCommand);
            futures.add(StageManager.getStage("ROW-READ-STAGE").submit(callable));
        }
        for (Future future : futures) {
            Row row;
            try {
                row = (Row)future.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            rows.add(row);
        }
        return rows;
    }

    public static List<Row> getRangeSlice(RangeSliceCommand command, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)command);
        }
        long startTime = System.nanoTime();
        String table = command.keyspace;
        int responseCount = StorageProxy.determineBlockFor(DatabaseDescriptor.getReplicationFactor(table), consistency_level);
        List<Pair<AbstractBounds, List<InetAddress>>> ranges = StorageProxy.getRestrictedRanges(command.range, command.keyspace, responseCount);
        ArrayList<Row> rows = new ArrayList<Row>(command.max_keys);
        for (Pair<AbstractBounds, List<InetAddress>> pair : StorageProxy.getRangeIterator(ranges, command.range.left)) {
            AbstractBounds range = (AbstractBounds)pair.left;
            List endpoints = (List)pair.right;
            RangeSliceCommand c2 = new RangeSliceCommand(command.keyspace, command.column_family, command.super_column, command.predicate, range, command.max_keys);
            Message message = c2.getMessage();
            RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(command.keyspace, endpoints);
            QuorumResponseHandler<List<Row>> handler = new QuorumResponseHandler<List<Row>>(responseCount, resolver);
            for (InetAddress endpoint : endpoints) {
                MessagingService.instance.sendRR(message, endpoint, handler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("reading " + c2 + " from " + message.getMessageId() + "@" + endpoint));
            }
            try {
                if (logger.isDebugEnabled()) {
                    for (Row row : handler.get()) {
                        logger.debug((Object)("range slices read " + row.key));
                    }
                }
                rows.addAll((Collection<Row>)handler.get());
            }
            catch (DigestMismatchException e) {
                throw new AssertionError((Object)e);
            }
            if (rows.size() < command.max_keys) continue;
            break;
        }
        rangeStats.addNano(System.nanoTime() - startTime);
        return rows.size() > command.max_keys ? rows.subList(0, command.max_keys) : rows;
    }

    private static Iterable<Pair<AbstractBounds, List<InetAddress>>> getRangeIterator(final List<Pair<AbstractBounds, List<InetAddress>>> ranges, Token start) {
        AbstractBounds range;
        int i;
        Comparator<Pair<AbstractBounds, List<InetAddress>>> comparator = new Comparator<Pair<AbstractBounds, List<InetAddress>>>(){

            @Override
            public int compare(Pair<AbstractBounds, List<InetAddress>> o1, Pair<AbstractBounds, List<InetAddress>> o2) {
                return ((AbstractBounds)o1.left).left.compareTo(((AbstractBounds)o2.left).left);
            }
        };
        Collections.sort(ranges, comparator);
        for (i = 0; i < ranges.size() && !(range = (AbstractBounds)ranges.get((int)i).left).contains(start) && !range.left.equals(start); ++i) {
        }
        range = (AbstractBounds)ranges.get((int)i).left;
        assert (range.contains(start) || range.left.equals(start));
        final int begin = i;
        return new Iterable<Pair<AbstractBounds, List<InetAddress>>>(){

            @Override
            public Iterator<Pair<AbstractBounds, List<InetAddress>>> iterator() {
                return new AbstractIterator<Pair<AbstractBounds, List<InetAddress>>>(){
                    int n = 0;

                    protected Pair<AbstractBounds, List<InetAddress>> computeNext() {
                        if (this.n == ranges.size()) {
                            return (Pair)this.endOfData();
                        }
                        return (Pair)ranges.get((begin + this.n++) % ranges.size());
                    }
                };
            }
        };
    }

    private static List<Pair<AbstractBounds, List<InetAddress>>> getRestrictedRanges(AbstractBounds queryRange, String keyspace, int responseCount) throws UnavailableException {
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        Iterator<Token> iter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left);
        ArrayList<Pair<AbstractBounds, List<InetAddress>>> ranges = new ArrayList<Pair<AbstractBounds, List<InetAddress>>>();
        while (iter.hasNext()) {
            Token nodeToken = iter.next();
            Range nodeRange = new Range(tokenMetadata.getPredecessor(nodeToken), nodeToken);
            List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, nodeToken);
            if (endpoints.size() < responseCount) {
                throw new UnavailableException();
            }
            DatabaseDescriptor.getEndPointSnitch(keyspace).sortByProximity(FBUtilities.getLocalAddress(), endpoints);
            List<InetAddress> endpointsForCL = endpoints.subList(0, responseCount);
            Set<AbstractBounds> restrictedRanges = queryRange.restrictTo(nodeRange);
            for (AbstractBounds range : restrictedRanges) {
                for (AbstractBounds unwrapped : range.unwrap()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding to restricted ranges " + unwrapped + " for " + nodeRange));
                    }
                    ranges.add(new Pair<AbstractBounds, List<InetAddress>>(unwrapped, endpointsForCL));
                }
            }
        }
        return ranges;
    }

    @Override
    public long getReadOperations() {
        return readStats.getOpCount();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return readStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readStats.getRecentLatencyMicros();
    }

    @Override
    public long getRangeOperations() {
        return rangeStats.getOpCount();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return rangeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeStats.getRecentLatencyMicros();
    }

    @Override
    public long getWriteOperations() {
        return writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeStats.getRecentLatencyMicros();
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName("org.apache.cassandra.service:type=StorageProxy"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        keyComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                IPartitioner p = StorageService.getPartitioner();
                return p.decorateKey(o1).compareTo(p.decorateKey(o2));
            }
        };
    }

    static class weakReadLocalCallable
    implements Callable<Object> {
        private ReadCommand command;

        weakReadLocalCallable(ReadCommand command) {
            this.command = command;
        }

        @Override
        public Object call() throws IOException {
            List<InetAddress> endpoints;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("weakreadlocal reading " + this.command));
            }
            Table table = Table.open(this.command.table);
            Row row = this.command.getRow(table);
            if (DatabaseDescriptor.getConsistencyCheck() && (endpoints = StorageService.instance.getLiveNaturalEndpoints(this.command.table, this.command.key)).size() > 1) {
                StorageService.instance.doConsistencyCheck(row, endpoints, this.command);
            }
            return row;
        }
    }
}

