/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BinaryVerbHandler;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutationVerbHandler;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndPointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.io.DeletionService;
import org.apache.cassandra.io.IndexSummary;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndPointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ResponseVerbHandler;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.ConsistencyChecker;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.StorageLoadBalancer;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.streaming.StreamFinishedVerbHandler;
import org.apache.cassandra.streaming.StreamIn;
import org.apache.cassandra.streaming.StreamInitiateDoneVerbHandler;
import org.apache.cassandra.streaming.StreamInitiateVerbHandler;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamRequestVerbHandler;
import org.apache.cassandra.streaming.StreamingService;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class StorageService
implements IEndPointStateChangeSubscriber,
StorageServiceMBean {
    private static Logger logger_ = Logger.getLogger(StorageService.class);
    public static final int RING_DELAY = 30000;
    public static final String MOVE_STATE = "MOVE";
    public static final char Delimiter = ',';
    public static final String STATE_BOOTSTRAPPING = "BOOT";
    public static final String STATE_NORMAL = "NORMAL";
    public static final String STATE_LEAVING = "LEAVING";
    public static final String STATE_LEFT = "LEFT";
    public static final String REMOVE_TOKEN = "remove";
    public static final String LEFT_NORMALLY = "left";
    public static final Verb[] VERBS = Verb.values();
    private static IPartitioner partitioner_ = DatabaseDescriptor.getPartitioner();
    public static final StorageService instance = new StorageService();
    private TokenMetadata tokenMetadata_ = new TokenMetadata();
    private SystemTable.StorageMetadata storageMetadata_;
    private ExecutorService consistencyManager_ = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getConsistencyThreads(), DatabaseDescriptor.getConsistencyThreads(), Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("CONSISTENCY-MANAGER"));
    private Map<String, AbstractReplicationStrategy> replicationStrategies;
    private boolean isBootstrapMode;
    private Multimap<InetAddress, String> bootstrapSet;
    private boolean isClientMode;
    private boolean initialized;
    private String operationMode;

    public static IPartitioner getPartitioner() {
        return partitioner_;
    }

    public Collection<Range> getLocalRanges(String table) {
        return this.getRangesForEndPoint(table, FBUtilities.getLocalAddress());
    }

    public Range getLocalPrimaryRange() {
        return this.getPrimaryRangeForEndPoint(FBUtilities.getLocalAddress());
    }

    public void addBootstrapSource(InetAddress s, String table) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("Added %s/%s as a bootstrap source", s, table));
        }
        this.bootstrapSet.put((Object)s, (Object)table);
    }

    public void removeBootstrapSource(InetAddress s, String table) {
        if (table == null) {
            this.bootstrapSet.removeAll((Object)s);
        } else {
            this.bootstrapSet.remove((Object)s, (Object)table);
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)String.format("Removed %s/%s as a bootstrap source; remaining is [%s]", s, table == null ? "<ALL>" : table, StringUtils.join((Collection)this.bootstrapSet.keySet(), (String)", ")));
        }
        if (this.bootstrapSet.isEmpty()) {
            this.finishBootstrapping();
        }
    }

    private void finishBootstrapping() {
        this.isBootstrapMode = false;
        SystemTable.setBootstrapped(true);
        this.setToken(this.getLocalToken());
        Gossiper.instance.addLocalApplicationState(MOVE_STATE, new ApplicationState("NORMAL," + partitioner_.getTokenFactory().toString(this.getLocalToken())));
        logger_.info((Object)"Bootstrap/move completed! Now serving reads.");
        this.setMode("Normal", false);
    }

    public void setToken(Token token) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Setting token to " + token));
        }
        SystemTable.updateToken(token);
        this.tokenMetadata_.updateNormalToken(token, FBUtilities.getLocalAddress());
    }

    public StorageService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.service:type=StorageService"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.bootstrapSet = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
        MessagingService.instance.registerVerbHandlers(Verb.BINARY, new BinaryVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.MUTATION, new RowMutationVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.READ_REPAIR, new ReadRepairVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.READ, new ReadVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.RANGE_SLICE, new RangeSliceVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.BOOTSTRAP_TOKEN, new BootStrapper.BootstrapTokenVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.STREAM_REQUEST, new StreamRequestVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.STREAM_INITIATE, new StreamInitiateVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.STREAM_INITIATE_DONE, new StreamInitiateDoneVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.STREAM_FINISHED, new StreamFinishedVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.READ_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.TREE_REQUEST, new AntiEntropyService.TreeRequestVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.TREE_RESPONSE, new AntiEntropyService.TreeResponseVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.JOIN, new Gossiper.JoinVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.GOSSIP_DIGEST_SYN, new Gossiper.GossipDigestSynVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.GOSSIP_DIGEST_ACK, new Gossiper.GossipDigestAckVerbHandler());
        MessagingService.instance.registerVerbHandlers(Verb.GOSSIP_DIGEST_ACK2, new Gossiper.GossipDigestAck2VerbHandler());
        this.replicationStrategies = new HashMap<String, AbstractReplicationStrategy>();
        for (String table : DatabaseDescriptor.getNonSystemTables()) {
            AbstractReplicationStrategy strat = StorageService.getReplicationStrategy(this.tokenMetadata_, table);
            this.replicationStrategies.put(table, strat);
        }
        this.replicationStrategies = Collections.unmodifiableMap(this.replicationStrategies);
        if (StreamingService.instance == null) {
            throw new RuntimeException("Streaming service is unavailable.");
        }
    }

    public AbstractReplicationStrategy getReplicationStrategy(String table) {
        AbstractReplicationStrategy ars = this.replicationStrategies.get(table);
        if (ars == null) {
            throw new RuntimeException(String.format("No replica strategy configured for %s", table));
        }
        return ars;
    }

    public static AbstractReplicationStrategy getReplicationStrategy(TokenMetadata tokenMetadata, String table) {
        AbstractReplicationStrategy replicationStrategy = null;
        Class<? extends AbstractReplicationStrategy> cls = DatabaseDescriptor.getReplicaPlacementStrategyClass(table);
        if (cls == null) {
            throw new RuntimeException(String.format("No replica strategy configured for %s", table));
        }
        Class[] parameterTypes = new Class[]{TokenMetadata.class, IEndPointSnitch.class};
        try {
            Constructor<? extends AbstractReplicationStrategy> constructor = cls.getConstructor(parameterTypes);
            replicationStrategy = constructor.newInstance(tokenMetadata, DatabaseDescriptor.getEndPointSnitch(table));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return replicationStrategy;
    }

    public void stopClient() {
        Gossiper.instance.unregister(this);
        Gossiper.instance.stop();
        MessagingService.shutdown();
        StageManager.shutdownNow();
    }

    public synchronized void initClient() throws IOException {
        if (this.initialized) {
            if (!this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = true;
        logger_.info((Object)"Starting up client gossip");
        MessagingService.instance.listen(FBUtilities.getLocalAddress());
        Gossiper.instance.register(this);
        Gossiper.instance.start(FBUtilities.getLocalAddress(), (int)(System.currentTimeMillis() / 1000L));
        this.setMode("Client", false);
    }

    public synchronized void initServer() throws IOException {
        if (this.initialized) {
            if (this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = false;
        this.storageMetadata_ = SystemTable.initMetadata();
        if (!Arrays.equals(this.storageMetadata_.getClusterName(), DatabaseDescriptor.getClusterName().getBytes())) {
            logger_.error((Object)("ClusterName mismatch: " + new String(this.storageMetadata_.getClusterName()) + " != " + DatabaseDescriptor.getClusterName()));
            System.exit(3);
        }
        DatabaseDescriptor.createAllDirectories();
        GCInspector.instance.start();
        logger_.info((Object)"Starting up server gossip");
        MessagingService.instance.listen(FBUtilities.getLocalAddress());
        StorageLoadBalancer.instance.startBroadcasting();
        Gossiper.instance.register(this);
        Gossiper.instance.start(FBUtilities.getLocalAddress(), this.storageMetadata_.getGeneration());
        if (DatabaseDescriptor.isAutoBootstrap() && DatabaseDescriptor.getSeeds().contains(FBUtilities.getLocalAddress()) && !SystemTable.isBootstrapped()) {
            logger_.info((Object)"This node will not auto bootstrap because it is configured to be a seed node.");
        }
        if (DatabaseDescriptor.isAutoBootstrap() && !DatabaseDescriptor.getSeeds().contains(FBUtilities.getLocalAddress()) && !SystemTable.isBootstrapped()) {
            this.setMode("Joining: getting load information", true);
            StorageLoadBalancer.instance.waitForLoadInfo();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"... got load info");
            }
            if (this.tokenMetadata_.isMember(FBUtilities.getLocalAddress())) {
                String s = "This node is already a member of the token ring; bootstrap aborted. (If replacing a dead node, remove the old one from the ring first.)";
                throw new UnsupportedOperationException(s);
            }
            this.setMode("Joining: getting bootstrap token", true);
            Token token = BootStrapper.getBootstrapToken(this.tokenMetadata_, StorageLoadBalancer.instance.getLoadInfo());
            this.startBootstrap(token);
            while (this.isBootstrapMode) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        } else {
            SystemTable.setBootstrapped(true);
            Token token = this.storageMetadata_.getToken();
            this.tokenMetadata_.updateNormalToken(token, FBUtilities.getLocalAddress());
            Gossiper.instance.addLocalApplicationState(MOVE_STATE, new ApplicationState("NORMAL," + partitioner_.getTokenFactory().toString(token)));
            this.setMode("Normal", false);
        }
        assert (this.tokenMetadata_.sortedTokens().size() > 0);
    }

    private void setMode(String m, boolean log) {
        this.operationMode = m;
        if (log) {
            logger_.info((Object)m);
        }
    }

    private void startBootstrap(Token token) throws IOException {
        this.isBootstrapMode = true;
        SystemTable.updateToken(token);
        Gossiper.instance.addLocalApplicationState(MOVE_STATE, new ApplicationState("BOOT," + partitioner_.getTokenFactory().toString(token)));
        this.setMode("Joining: sleeping 30000 for pending range setup", true);
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.setMode("Bootstrapping", true);
        new BootStrapper(FBUtilities.getLocalAddress(), token, this.tokenMetadata_).startBootstrap();
    }

    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata_;
    }

    public void doConsistencyCheck(Row row, List<InetAddress> endpoints, ReadCommand command) {
        this.consistencyManager_.submit(new ConsistencyChecker(command.table, row, endpoints, command));
    }

    @Override
    public Map<Range, List<String>> getRangeToEndPointMap(String keyspace) {
        if (keyspace == null) {
            keyspace = DatabaseDescriptor.getNonSystemTables().get(0);
        }
        HashMap<Range, List<String>> map = new HashMap<Range, List<String>>();
        for (Map.Entry<Range, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            map.put(entry.getKey(), this.stringify(entry.getValue()));
        }
        return map;
    }

    public Map<Range, List<InetAddress>> getRangeToAddressMap(String keyspace) {
        List<Range> ranges = this.getAllRanges(this.tokenMetadata_.sortedTokens());
        return this.constructRangeToEndPointMap(keyspace, ranges);
    }

    private Map<Range, List<InetAddress>> constructRangeToEndPointMap(String keyspace, List<Range> ranges) {
        HashMap<Range, List<InetAddress>> rangeToEndPointMap = new HashMap<Range, List<InetAddress>>();
        for (Range range : ranges) {
            rangeToEndPointMap.put(range, this.getReplicationStrategy(keyspace).getNaturalEndpoints(range.right, keyspace));
        }
        return rangeToEndPointMap;
    }

    @Override
    public void onChange(InetAddress endpoint, String apStateName, ApplicationState apState) {
        if (!MOVE_STATE.equals(apStateName)) {
            return;
        }
        String apStateValue = apState.getValue();
        int index = apStateValue.indexOf(44);
        assert (index != -1);
        String moveName = apStateValue.substring(0, index);
        String moveValue = apStateValue.substring(index + 1);
        if (moveName.equals(STATE_BOOTSTRAPPING)) {
            this.handleStateBootstrap(endpoint, moveValue);
        } else if (moveName.equals(STATE_NORMAL)) {
            this.handleStateNormal(endpoint, moveValue);
        } else if (moveName.equals(STATE_LEAVING)) {
            this.handleStateLeaving(endpoint, moveValue);
        } else if (moveName.equals(STATE_LEFT)) {
            this.handleStateLeft(endpoint, moveValue);
        }
    }

    private void handleStateBootstrap(InetAddress endPoint, String moveValue) {
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(moveValue);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Node " + endPoint + " state bootstrapping, token " + token));
        }
        if (this.tokenMetadata_.isMember(endPoint)) {
            if (!this.tokenMetadata_.isLeaving(endPoint)) {
                logger_.info((Object)("Node " + endPoint + " state jump to bootstrap"));
            }
            this.tokenMetadata_.removeEndpoint(endPoint);
        }
        this.tokenMetadata_.addBootstrapToken(token, endPoint);
        this.calculatePendingRanges();
    }

    private void handleStateNormal(InetAddress endPoint, String moveValue) {
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(moveValue);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Node " + endPoint + " state normal, token " + token));
        }
        if (this.tokenMetadata_.isMember(endPoint)) {
            logger_.info((Object)("Node " + endPoint + " state jump to normal"));
        }
        this.tokenMetadata_.updateNormalToken(token, endPoint);
        this.calculatePendingRanges();
        if (!this.isClientMode) {
            SystemTable.updateToken(endPoint, token);
        }
    }

    private void handleStateLeaving(InetAddress endPoint, String moveValue) {
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(moveValue);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Node " + endPoint + " state leaving, token " + token));
        }
        if (!this.tokenMetadata_.isMember(endPoint)) {
            logger_.info((Object)("Node " + endPoint + " state jump to leaving"));
            this.tokenMetadata_.updateNormalToken(token, endPoint);
        } else if (!this.tokenMetadata_.getToken(endPoint).equals(token)) {
            logger_.warn((Object)("Node " + endPoint + " 'leaving' token mismatch. Long network partition?"));
            this.tokenMetadata_.updateNormalToken(token, endPoint);
        }
        this.tokenMetadata_.addLeavingEndPoint(endPoint);
        this.calculatePendingRanges();
    }

    private void handleStateLeft(InetAddress endPoint, String moveValue) {
        int index = moveValue.indexOf(44);
        assert (index != -1);
        String typeOfState = moveValue.substring(0, index);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(moveValue.substring(index + 1));
        if (typeOfState.equals(LEFT_NORMALLY)) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Node " + endPoint + " state left, token " + token));
            }
            if (this.tokenMetadata_.isMember(endPoint)) {
                if (!this.tokenMetadata_.getToken(endPoint).equals(token)) {
                    logger_.warn((Object)("Node " + endPoint + " 'left' token mismatch. Long network partition?"));
                }
                this.tokenMetadata_.removeEndpoint(endPoint);
            }
        } else {
            assert (typeOfState.equals(REMOVE_TOKEN));
            InetAddress endPointThatLeft = this.tokenMetadata_.getEndPoint(token);
            if (FBUtilities.getLocalAddress().equals(endPointThatLeft)) {
                logger_.info((Object)"Received removeToken gossip about myself. Is this node a replacement for a removed one?");
                return;
            }
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Token " + token + " removed manually (endpoint was " + (endPointThatLeft == null ? "unknown" : endPointThatLeft) + ")"));
            }
            if (endPointThatLeft != null) {
                this.removeEndPointLocally(endPointThatLeft);
            }
        }
        this.tokenMetadata_.removeBootstrapToken(token);
        this.calculatePendingRanges();
    }

    private void removeEndPointLocally(InetAddress endPoint) {
        this.restoreReplicaCount(endPoint);
        Gossiper.instance.removeEndPoint(endPoint);
        this.tokenMetadata_.removeEndpoint(endPoint);
    }

    private void calculatePendingRanges() {
        for (String table : DatabaseDescriptor.getNonSystemTables()) {
            StorageService.calculatePendingRanges(this.getReplicationStrategy(table), table);
        }
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String table) {
        TokenMetadata tm = instance.getTokenMetadata();
        HashMultimap pendingRanges = HashMultimap.create();
        Map<Token, InetAddress> bootstrapTokens = tm.getBootstrapTokens();
        Set<InetAddress> leavingEndPoints = tm.getLeavingEndPoints();
        if (bootstrapTokens.isEmpty() && leavingEndPoints.isEmpty()) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("No bootstrapping or leaving nodes -> empty pending ranges for " + table));
            }
            tm.setPendingRanges(table, (Multimap<Range, InetAddress>)pendingRanges);
            return;
        }
        Multimap<InetAddress, Range> addressRanges = strategy.getAddressRanges(table);
        TokenMetadata allLeftMetadata = tm.cloneAfterAllLeft();
        HashSet affectedRanges = new HashSet();
        for (InetAddress inetAddress : leavingEndPoints) {
            affectedRanges.addAll(addressRanges.get((Object)inetAddress));
        }
        for (Range range : affectedRanges) {
            ArrayList<InetAddress> currentEndPoints = strategy.getNaturalEndpoints(range.right, tm, table);
            ArrayList<InetAddress> newEndPoints = strategy.getNaturalEndpoints(range.right, allLeftMetadata, table);
            newEndPoints.removeAll(currentEndPoints);
            pendingRanges.putAll((Object)range, newEndPoints);
        }
        for (Map.Entry entry : bootstrapTokens.entrySet()) {
            InetAddress endPoint = (InetAddress)entry.getValue();
            allLeftMetadata.updateNormalToken((Token)entry.getKey(), endPoint);
            for (Range range : strategy.getAddressRanges(allLeftMetadata, table).get((Object)endPoint)) {
                pendingRanges.put((Object)range, (Object)endPoint);
            }
            allLeftMetadata.removeEndpoint(endPoint);
        }
        tm.setPendingRanges(table, (Multimap<Range, InetAddress>)pendingRanges);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Pending ranges:\n" + (pendingRanges.isEmpty() ? "<empty>" : tm.printPendingRanges())));
        }
    }

    private void restoreReplicaCount(InetAddress endPoint) {
        InetAddress myAddress = FBUtilities.getLocalAddress();
        for (String table : DatabaseDescriptor.getNonSystemTables()) {
            Multimap<Range, InetAddress> changedRanges = this.getChangedRangesForLeaving(table, endPoint);
            HashSet myNewRanges = new HashSet();
            for (Map.Entry entry : changedRanges.entries()) {
                if (!((InetAddress)entry.getValue()).equals(myAddress)) continue;
                myNewRanges.add(entry.getKey());
            }
            if (myNewRanges.isEmpty()) continue;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)(endPoint + " was removed, my added ranges: " + StringUtils.join(myNewRanges, (String)", ")));
            }
            Multimap<Range, InetAddress> rangeAddresses = this.getReplicationStrategy(table).getRangeAddresses(this.tokenMetadata_, table);
            HashMultimap sourceRanges = HashMultimap.create();
            IFailureDetector failureDetector = FailureDetector.instance;
            block2: for (Range range : myNewRanges) {
                List<InetAddress> sources = DatabaseDescriptor.getEndPointSnitch(table).getSortedListByProximity(myAddress, rangeAddresses.get((Object)range));
                assert (!sources.contains(myAddress));
                for (InetAddress source : sources) {
                    if (source.equals(endPoint) || !failureDetector.isAlive(source)) continue;
                    sourceRanges.put((Object)source, (Object)range);
                    continue block2;
                }
            }
            for (Map.Entry entry : sourceRanges.asMap().entrySet()) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Requesting from " + entry.getKey() + " ranges " + StringUtils.join((Collection)((Collection)entry.getValue()), (String)", ")));
                }
                StreamIn.requestRanges((InetAddress)entry.getKey(), table, (Collection)entry.getValue());
            }
        }
    }

    private Multimap<Range, InetAddress> getChangedRangesForLeaving(String table, InetAddress endpoint) {
        Collection<Range> ranges = this.getRangesForEndPoint(table, endpoint);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Node " + endpoint + " ranges [" + StringUtils.join(ranges, (String)", ") + "]"));
        }
        HashMap<Range, ArrayList<InetAddress>> currentReplicaEndpoints = new HashMap<Range, ArrayList<InetAddress>>();
        for (Range range : ranges) {
            currentReplicaEndpoints.put(range, this.getReplicationStrategy(table).getNaturalEndpoints(range.right, this.tokenMetadata_, table));
        }
        TokenMetadata temp = this.tokenMetadata_.cloneAfterAllLeft();
        if (temp.isMember(endpoint)) {
            temp.removeEndpoint(endpoint);
        }
        HashMultimap changedRanges = HashMultimap.create();
        for (Range range : ranges) {
            ArrayList<InetAddress> newReplicaEndpoints = this.getReplicationStrategy(table).getNaturalEndpoints(range.right, temp, table);
            newReplicaEndpoints.removeAll((Collection)currentReplicaEndpoints.get(range));
            if (logger_.isDebugEnabled()) {
                if (newReplicaEndpoints.isEmpty()) {
                    logger_.debug((Object)("Range " + range + " already in all replicas"));
                } else {
                    logger_.debug((Object)("Range " + range + " will be responsibility of " + StringUtils.join(newReplicaEndpoints, (String)", ")));
                }
            }
            changedRanges.putAll((Object)range, newReplicaEndpoints);
        }
        return changedRanges;
    }

    @Override
    public void onJoin(InetAddress endpoint, EndPointState epState) {
        for (Map.Entry<String, ApplicationState> entry : epState.getSortedApplicationStates()) {
            this.onChange(endpoint, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndPointState state) {
        if (!this.isClientMode) {
            this.deliverHints(endpoint);
        }
    }

    @Override
    public void onDead(InetAddress endpoint, EndPointState state) {
    }

    @Override
    public double getLoad() {
        double bytes = 0.0;
        for (String tableName : DatabaseDescriptor.getTables()) {
            Table table;
            try {
                table = Table.open(tableName);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            for (String cfName : table.getColumnFamilies()) {
                ColumnFamilyStore cfs = table.getColumnFamilyStore(cfName);
                bytes += (double)cfs.getLiveDiskSpaceUsed();
            }
        }
        return bytes;
    }

    @Override
    public String getLoadString() {
        return FileUtils.stringifyFileSize(this.getLoad());
    }

    @Override
    public Map<String, String> getLoadMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<InetAddress, Double> entry : StorageLoadBalancer.instance.getLoadInfo().entrySet()) {
            map.put(entry.getKey().getHostAddress(), FileUtils.stringifyFileSize(entry.getValue()));
        }
        map.put(FBUtilities.getLocalAddress().getHostAddress(), this.getLoadString());
        return map;
    }

    public final void deliverHints(InetAddress endpoint) {
        HintedHandOffManager.instance.deliverHints(endpoint);
    }

    public Token getLocalToken() {
        return this.storageMetadata_.getToken();
    }

    @Override
    public String getToken() {
        return this.getLocalToken().toString();
    }

    @Override
    public Set<String> getLiveNodes() {
        return this.stringify(Gossiper.instance.getLiveMembers());
    }

    @Override
    public Set<String> getUnreachableNodes() {
        return this.stringify(Gossiper.instance.getUnreachableMembers());
    }

    private Set<String> stringify(Set<InetAddress> endPoints) {
        HashSet<String> stringEndPoints = new HashSet<String>();
        for (InetAddress ep : endPoints) {
            stringEndPoints.add(ep.getHostAddress());
        }
        return stringEndPoints;
    }

    private List<String> stringify(List<InetAddress> endPoints) {
        ArrayList<String> stringEndPoints = new ArrayList<String>();
        for (InetAddress ep : endPoints) {
            stringEndPoints.add(ep.getHostAddress());
        }
        return stringEndPoints;
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance.getCurrentGenerationNumber(FBUtilities.getLocalAddress());
    }

    @Override
    public void forceTableCleanup() throws IOException {
        List<String> tables = DatabaseDescriptor.getNonSystemTables();
        for (String tName : tables) {
            Table table = Table.open(tName);
            table.forceCleanup();
        }
    }

    @Override
    public void forceTableCompaction() throws IOException {
        for (Table table : Table.all()) {
            table.forceCompaction();
        }
    }

    @Override
    public void takeSnapshot(String tableName, String tag) throws IOException {
        Table tableInstance = this.getValidTable(tableName);
        tableInstance.snapshot(tag);
    }

    private Table getValidTable(String tableName) throws IOException {
        if (!DatabaseDescriptor.getTables().contains(tableName)) {
            throw new IOException("Table " + tableName + "does not exist");
        }
        return Table.open(tableName);
    }

    @Override
    public void takeAllSnapshot(String tag) throws IOException {
        for (Table table : Table.all()) {
            table.snapshot(tag);
        }
    }

    @Override
    public void clearSnapshot() throws IOException {
        for (Table table : Table.all()) {
            table.clearSnapshot();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"Cleared out all snapshot directories");
        }
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(String tableName, String ... columnFamilies) throws IOException {
        Table table = this.getValidTable(tableName);
        HashSet<ColumnFamilyStore> valid = new HashSet<ColumnFamilyStore>();
        for (String cfName : columnFamilies.length == 0 ? table.getColumnFamilies() : Arrays.asList(columnFamilies)) {
            ColumnFamilyStore cfStore = table.getColumnFamilyStore(cfName);
            if (cfStore == null) {
                logger_.warn((Object)String.format("Invalid column family specified: %s. Proceeding with others.", cfName));
                continue;
            }
            valid.add(cfStore);
        }
        return valid;
    }

    @Override
    public void forceTableFlush(String tableName, String ... columnFamilies) throws IOException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            logger_.debug((Object)("Forcing binary flush on keyspace " + tableName + ", CF " + cfStore.getColumnFamilyName()));
            cfStore.forceFlushBinary();
            logger_.debug((Object)("Forcing flush on keyspace " + tableName + ", CF " + cfStore.getColumnFamilyName()));
            cfStore.forceFlush();
        }
    }

    @Override
    public void forceTableRepair(String tableName, String ... columnFamilies) throws IOException {
        MessagingService ms = MessagingService.instance;
        Set<InetAddress> endpoints = AntiEntropyService.getNeighbors(tableName);
        endpoints.add(FBUtilities.getLocalAddress());
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(tableName, columnFamilies)) {
            Message request = AntiEntropyService.TreeRequestVerbHandler.makeVerb(tableName, cfStore.getColumnFamilyName());
            for (InetAddress endpoint : endpoints) {
                ms.sendOneWay(request, endpoint);
            }
        }
    }

    InetAddress getPredecessor(InetAddress ep) {
        Token token = this.tokenMetadata_.getToken(ep);
        return this.tokenMetadata_.getEndPoint(this.tokenMetadata_.getPredecessor(token));
    }

    public InetAddress getSuccessor(InetAddress ep) {
        Token token = this.tokenMetadata_.getToken(ep);
        return this.tokenMetadata_.getEndPoint(this.tokenMetadata_.getSuccessor(token));
    }

    public Range getPrimaryRangeForEndPoint(InetAddress ep) {
        return this.tokenMetadata_.getPrimaryRangeFor(this.tokenMetadata_.getToken(ep));
    }

    Collection<Range> getRangesForEndPoint(String table, InetAddress ep) {
        return this.getReplicationStrategy(table).getAddressRanges(table).get((Object)ep);
    }

    public List<Range> getAllRanges(List<Token> sortedTokens) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("computing ranges for " + StringUtils.join(sortedTokens, (String)", ")));
        }
        if (sortedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        int size = sortedTokens.size();
        for (int i = 1; i < size; ++i) {
            Range range = new Range(sortedTokens.get(i - 1), sortedTokens.get(i));
            ranges.add(range);
        }
        Range range = new Range(sortedTokens.get(size - 1), sortedTokens.get(0));
        ranges.add(range);
        return ranges;
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String table, String key) {
        return this.getNaturalEndpoints(table, (Token)partitioner_.getToken(key));
    }

    public List<InetAddress> getNaturalEndpoints(String table, Token token) {
        return this.getReplicationStrategy(table).getNaturalEndpoints(token, table);
    }

    public List<InetAddress> getLiveNaturalEndpoints(String table, String key) {
        return this.getLiveNaturalEndpoints(table, (Token)partitioner_.getToken(key));
    }

    public List<InetAddress> getLiveNaturalEndpoints(String table, Token token) {
        ArrayList<InetAddress> liveEps = new ArrayList<InetAddress>();
        ArrayList<InetAddress> endpoints = this.getReplicationStrategy(table).getNaturalEndpoints(token, table);
        for (InetAddress endpoint : endpoints) {
            if (!FailureDetector.instance.isAlive(endpoint)) continue;
            liveEps.add(endpoint);
        }
        return liveEps;
    }

    public InetAddress findSuitableEndPoint(String table, String key) throws IOException, UnavailableException {
        List<InetAddress> endpoints = this.getNaturalEndpoints(table, key);
        DatabaseDescriptor.getEndPointSnitch(table).sortByProximity(FBUtilities.getLocalAddress(), endpoints);
        for (InetAddress endpoint : endpoints) {
            if (!FailureDetector.instance.isAlive(endpoint)) continue;
            return endpoint;
        }
        throw new UnavailableException();
    }

    public Map<String, String> getStringEndpointMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Token t : this.tokenMetadata_.sortedTokens()) {
            map.put(t.toString(), this.tokenMetadata_.getEndPoint(t).getHostAddress());
        }
        return map;
    }

    @Override
    public void setLog4jLevel(String classQualifier, String rawLevel) {
        Level level = Level.toLevel((String)rawLevel);
        Logger.getLogger((String)classQualifier).setLevel(level);
        logger_.info((Object)("set log level to " + level + " for classes under '" + classQualifier + "' (if the level doesn't look like '" + rawLevel + "' then log4j couldn't parse '" + rawLevel + "')"));
    }

    public List<Token> getSplits(Range range, int keysPerSplit) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        tokens.add(range.left);
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            for (IndexSummary.KeyPosition info : cfs.allIndexPositions()) {
                if (!range.contains((Token)info.key.token)) continue;
                keys.add(info.key);
            }
        }
        FBUtilities.sortSampledKeys(keys, range);
        int splits = keys.size() * SSTableReader.indexInterval() / keysPerSplit;
        if (keys.size() >= splits) {
            for (int i = 1; i < splits; ++i) {
                int index = i * (keys.size() / splits);
                tokens.add((Token)((DecoratedKey)keys.get((int)index)).token);
            }
        }
        tokens.add(range.right);
        return tokens;
    }

    public Token getBootstrapToken() {
        Range range = this.getLocalPrimaryRange();
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            for (IndexSummary.KeyPosition info : cfs.allIndexPositions()) {
                if (!range.contains((Token)info.key.token)) continue;
                keys.add(info.key);
            }
        }
        FBUtilities.sortSampledKeys(keys, range);
        if (keys.size() < 3) {
            return partitioner_.getRandomToken();
        }
        return ((DecoratedKey)keys.get((int)(keys.size() / 2))).token;
    }

    private void startLeaving() {
        Gossiper.instance.addLocalApplicationState(MOVE_STATE, new ApplicationState("LEAVING," + this.getLocalToken().toString()));
        this.tokenMetadata_.addLeavingEndPoint(FBUtilities.getLocalAddress());
        this.calculatePendingRanges();
    }

    @Override
    public void decommission() throws InterruptedException {
        if (!this.tokenMetadata_.isMember(FBUtilities.getLocalAddress())) {
            throw new UnsupportedOperationException("local node is not a member of the token ring yet");
        }
        if (this.tokenMetadata_.cloneAfterAllLeft().sortedTokens().size() < 2) {
            throw new UnsupportedOperationException("no other normal nodes in the ring; decommission would be pointless");
        }
        for (String table : DatabaseDescriptor.getNonSystemTables()) {
            if (this.tokenMetadata_.getPendingRanges(table, FBUtilities.getLocalAddress()).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)"DECOMMISSIONING");
        }
        this.startLeaving();
        this.setMode("Leaving: sleeping 30000 for pending range setup", true);
        Thread.sleep(30000L);
        Runnable finishLeaving = new Runnable(){

            @Override
            public void run() {
                Gossiper.instance.stop();
                MessagingService.shutdown();
                StageManager.shutdownNow();
                StorageService.this.setMode("Decommissioned", true);
            }
        };
        this.unbootstrap(finishLeaving);
    }

    private void leaveRing() {
        SystemTable.setBootstrapped(false);
        this.tokenMetadata_.removeEndpoint(FBUtilities.getLocalAddress());
        this.calculatePendingRanges();
        Gossiper.instance.addLocalApplicationState(MOVE_STATE, new ApplicationState("LEFT,left," + this.getLocalToken().toString()));
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void unbootstrap(Runnable onFinish) {
        final CountDownLatch latch = new CountDownLatch(DatabaseDescriptor.getNonSystemTables().size());
        for (final String table : DatabaseDescriptor.getNonSystemTables()) {
            Multimap<Range, InetAddress> rangesMM = this.getChangedRangesForLeaving(table, FBUtilities.getLocalAddress());
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Ranges needing transfer are [" + StringUtils.join((Collection)rangesMM.keySet(), (String)",") + "]"));
            }
            if (rangesMM.isEmpty()) {
                latch.countDown();
                continue;
            }
            this.setMode("Leaving: streaming data to other nodes", true);
            final Set pending = Collections.synchronizedSet(new HashSet(rangesMM.entries()));
            for (final Map.Entry entry : rangesMM.entries()) {
                final Range range = (Range)entry.getKey();
                final InetAddress newEndpoint = (InetAddress)entry.getValue();
                final Runnable callback = new Runnable(){

                    @Override
                    public void run() {
                        pending.remove(entry);
                        if (pending.isEmpty()) {
                            latch.countDown();
                        }
                    }
                };
                StageManager.getStage("STREAM-STAGE").execute(new Runnable(){

                    @Override
                    public void run() {
                        StreamOut.transferRanges(newEndpoint, table, Arrays.asList(range), callback);
                    }
                });
            }
        }
        logger_.debug((Object)"waiting for stream aks.");
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger_.debug((Object)"stream acks all received.");
        this.leaveRing();
        onFinish.run();
    }

    @Override
    public void move(String newToken) throws IOException, InterruptedException {
        this.move(partitioner_.getTokenFactory().fromString(newToken));
    }

    @Override
    public void loadBalance() throws IOException, InterruptedException {
        this.move((Token)null);
    }

    private void move(final Token token) throws IOException, InterruptedException {
        for (String table : DatabaseDescriptor.getTables()) {
            if (this.tokenMetadata_.getPendingRanges(table, FBUtilities.getLocalAddress()).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        if (token != null && this.tokenMetadata_.sortedTokens().contains(token)) {
            throw new IOException("target token " + token + " is already owned by another node");
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Leaving: old token was " + this.getLocalToken()));
        }
        this.startLeaving();
        this.setMode("Leaving: sleeping 30000 for pending range setup", true);
        Thread.sleep(30000L);
        WrappedRunnable finishMoving = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws IOException {
                Token bootstrapToken = token;
                if (bootstrapToken == null) {
                    StorageLoadBalancer.instance.waitForLoadInfo();
                    bootstrapToken = BootStrapper.getBalancedToken(StorageService.this.tokenMetadata_, StorageLoadBalancer.instance.getLoadInfo());
                }
                logger_.info((Object)("re-bootstrapping to new token " + bootstrapToken));
                StorageService.this.startBootstrap(bootstrapToken);
            }
        };
        this.unbootstrap(finishMoving);
    }

    @Override
    public void removeToken(String tokenString) {
        Token token = partitioner_.getTokenFactory().fromString(tokenString);
        InetAddress endPoint = this.tokenMetadata_.getEndPoint(token);
        if (endPoint != null) {
            if (endPoint.equals(FBUtilities.getLocalAddress())) {
                throw new UnsupportedOperationException("Cannot remove node's own token");
            }
            if (Gossiper.instance.getLiveMembers().contains(endPoint)) {
                throw new UnsupportedOperationException("Node " + endPoint + " is alive and owns this token. Use decommission command to remove it from the ring");
            }
            this.removeEndPointLocally(endPoint);
            this.calculatePendingRanges();
        }
        Gossiper.instance.addLocalApplicationState(MOVE_STATE, new ApplicationState("LEFT,remove," + token.toString()));
    }

    public WriteResponseHandler getWriteResponseHandler(int blockFor, ConsistencyLevel consistency_level, String table) {
        return this.getReplicationStrategy(table).getWriteResponseHandler(blockFor, consistency_level, table);
    }

    public boolean isClientMode() {
        return this.isClientMode;
    }

    public synchronized void requestGC() {
        if (this.hasUnreclaimedSpace()) {
            logger_.info((Object)"requesting GC to free disk space");
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private boolean hasUnreclaimedSpace() {
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (!cfs.hasUnreclaimedSpace()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOperationMode() {
        return this.operationMode;
    }

    @Override
    public synchronized void drain() throws IOException, InterruptedException, ExecutionException {
        ThreadPoolExecutor mutationStage = StageManager.getStage("ROW-MUTATION-STAGE");
        if (mutationStage.isTerminated()) {
            logger_.warn((Object)"Cannot drain node (did it already happen?)");
            return;
        }
        this.setMode("Starting drain process", true);
        Gossiper.instance.stop();
        this.setMode("Draining: shutting down MessageService", false);
        MessagingService.shutdown();
        this.setMode("Draining: emptying MessageService pools", false);
        MessagingService.waitFor();
        this.setMode("Draining: flushing column families", false);
        for (String tableName : DatabaseDescriptor.getNonSystemTables()) {
            for (Future<?> f : Table.open(tableName).flush()) {
                f.get();
            }
        }
        this.setMode("Draining: replaying commit log", false);
        CommitLog.instance().forceNewSegment();
        DeletionService.waitFor();
        CommitLog.recover();
        this.setMode("Draining: clearing mutation stage", false);
        mutationStage.shutdown();
        while (!mutationStage.isTerminated()) {
            mutationStage.awaitTermination(5L, TimeUnit.SECONDS);
        }
        this.setMode("Node is drained", true);
    }

    Map<String, AbstractReplicationStrategy> setReplicationStrategyUnsafe(Map<String, AbstractReplicationStrategy> replacement) {
        Map<String, AbstractReplicationStrategy> old = this.replicationStrategies;
        this.replicationStrategies = replacement;
        return old;
    }

    IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner oldPartitioner = partitioner_;
        partitioner_ = newPartitioner;
        return oldPartitioner;
    }

    TokenMetadata setTokenMetadataUnsafe(TokenMetadata tmd) {
        TokenMetadata old = this.tokenMetadata_;
        this.tokenMetadata_ = tmd;
        return old;
    }

    public static enum Verb {
        MUTATION,
        BINARY,
        READ_REPAIR,
        READ,
        READ_RESPONSE,
        STREAM_INITIATE,
        STREAM_INITIATE_DONE,
        STREAM_FINISHED,
        STREAM_REQUEST,
        RANGE_SLICE,
        BOOTSTRAP_TOKEN,
        TREE_REQUEST,
        TREE_RESPONSE,
        JOIN,
        GOSSIP_DIGEST_SYN,
        GOSSIP_DIGEST_ACK,
        GOSSIP_DIGEST_ACK2;

    }
}

