/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.log4j.Logger;

public class WriteResponseHandler
implements IAsyncCallback {
    protected static final Logger logger = Logger.getLogger(WriteResponseHandler.class);
    protected final SimpleCondition condition = new SimpleCondition();
    private final int responseCount;
    protected final Collection<Message> responses;
    protected AtomicInteger localResponses = new AtomicInteger(0);
    private final long startTime;

    public WriteResponseHandler(int responseCount, String table) {
        assert (1 <= responseCount && responseCount <= 2 * DatabaseDescriptor.getReplicationFactor(table)) : "invalid response count " + responseCount;
        this.responseCount = responseCount;
        this.responses = new LinkedBlockingQueue<Message>();
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get() throws TimeoutException {
        try {
            boolean success;
            long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
            try {
                success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                throw new AssertionError((Object)ex);
            }
            if (!success) {
                throw new TimeoutException("Operation timed out - received only " + this.responses.size() + this.localResponses + " responses");
            }
        }
        finally {
            for (Message response : this.responses) {
                MessagingService.removeRegisteredCallback(response.getMessageId());
            }
        }
    }

    @Override
    public void response(Message message) {
        this.responses.add(message);
        this.maybeSignal();
    }

    public void localResponse() {
        this.localResponses.addAndGet(1);
        this.maybeSignal();
    }

    private void maybeSignal() {
        if (this.responses.size() + this.localResponses.get() >= this.responseCount) {
            this.condition.signal();
        }
    }
}

