/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

class CompletedFileStatus {
    private static ICompactSerializer<CompletedFileStatus> serializer_ = new CompletedFileStatusSerializer();
    private String file_;
    private long expectedBytes_;
    private StreamCompletionAction action_;

    public static ICompactSerializer<CompletedFileStatus> serializer() {
        return serializer_;
    }

    public CompletedFileStatus(String file, long expectedBytes) {
        this.file_ = file;
        this.expectedBytes_ = expectedBytes;
        this.action_ = StreamCompletionAction.DELETE;
    }

    public String getFile() {
        return this.file_;
    }

    public long getExpectedBytes() {
        return this.expectedBytes_;
    }

    public void setAction(StreamCompletionAction action) {
        this.action_ = action;
    }

    public StreamCompletionAction getAction() {
        return this.action_;
    }

    public Message makeStreamStatusMessage() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        CompletedFileStatus.serializer().serialize(this, dos);
        return new Message(FBUtilities.getLocalAddress(), "", StorageService.Verb.STREAM_FINISHED, bos.toByteArray());
    }

    private static class CompletedFileStatusSerializer
    implements ICompactSerializer<CompletedFileStatus> {
        private CompletedFileStatusSerializer() {
        }

        @Override
        public void serialize(CompletedFileStatus streamStatus, DataOutputStream dos) throws IOException {
            dos.writeUTF(streamStatus.getFile());
            dos.writeLong(streamStatus.getExpectedBytes());
            dos.writeInt(streamStatus.getAction().ordinal());
        }

        @Override
        public CompletedFileStatus deserialize(DataInputStream dis) throws IOException {
            String targetFile = dis.readUTF();
            long expectedBytes = dis.readLong();
            CompletedFileStatus streamStatus = new CompletedFileStatus(targetFile, expectedBytes);
            int ordinal = dis.readInt();
            if (ordinal == StreamCompletionAction.DELETE.ordinal()) {
                streamStatus.setAction(StreamCompletionAction.DELETE);
            } else if (ordinal == StreamCompletionAction.STREAM.ordinal()) {
                streamStatus.setAction(StreamCompletionAction.STREAM);
            }
            return streamStatus;
        }
    }

    public static enum StreamCompletionAction {
        DELETE,
        STREAM;

    }
}

