/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;

class PendingFile {
    private static ICompactSerializer<PendingFile> serializer_ = new InitiatedFileSerializer();
    private String targetFile_;
    private final long expectedBytes_;
    private final String table_;
    private long ptr_;

    public static ICompactSerializer<PendingFile> serializer() {
        return serializer_;
    }

    public PendingFile(String targetFile, long expectedBytes, String table) {
        this.targetFile_ = targetFile;
        this.expectedBytes_ = expectedBytes;
        this.table_ = table;
        this.ptr_ = 0L;
    }

    public void update(long ptr) {
        this.ptr_ = ptr;
    }

    public long getPtr() {
        return this.ptr_;
    }

    public String getTable() {
        return this.table_;
    }

    public String getTargetFile() {
        return this.targetFile_;
    }

    public void setTargetFile(String file) {
        this.targetFile_ = file;
    }

    public long getExpectedBytes() {
        return this.expectedBytes_;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PendingFile)) {
            return false;
        }
        PendingFile rhs = (PendingFile)o;
        return this.targetFile_.hashCode() == rhs.hashCode();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.targetFile_ + ":" + this.expectedBytes_;
    }

    private static class InitiatedFileSerializer
    implements ICompactSerializer<PendingFile> {
        private InitiatedFileSerializer() {
        }

        @Override
        public void serialize(PendingFile sc, DataOutputStream dos) throws IOException {
            dos.writeUTF(sc.targetFile_);
            dos.writeLong(sc.expectedBytes_);
            dos.writeUTF(sc.table_);
        }

        @Override
        public PendingFile deserialize(DataInputStream dis) throws IOException {
            String targetFile = dis.readUTF();
            long expectedBytes = dis.readLong();
            String table = dis.readUTF();
            return new PendingFile(targetFile, expectedBytes, table);
        }
    }
}

