/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.CompletedFileStatus;
import org.apache.cassandra.streaming.IStreamComplete;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamInManager;
import org.apache.log4j.Logger;

class StreamCompletionHandler
implements IStreamComplete {
    private static Logger logger = Logger.getLogger(StreamCompletionHandler.class);

    StreamCompletionHandler() {
    }

    @Override
    public void onStreamCompletion(InetAddress host, PendingFile pendingFile, CompletedFileStatus streamStatus) throws IOException {
        if (pendingFile.getTargetFile().contains("-Data.db")) {
            String tableName = pendingFile.getTable();
            File file = new File(pendingFile.getTargetFile());
            String fileName = file.getName();
            String[] temp = fileName.split("-");
            try {
                SSTableReader sstable = SSTableWriter.renameAndOpen(pendingFile.getTargetFile());
                Table.open(tableName).getColumnFamilyStore(temp[0]).addSSTable(sstable);
                logger.info((Object)("Streaming added " + sstable.getFilename()));
            }
            catch (IOException e) {
                throw new RuntimeException("Not able to add streamed file " + pendingFile.getTargetFile(), e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Sending a streaming finished message with " + streamStatus + " to " + host));
        }
        MessagingService.instance.sendOneWay(streamStatus.makeStreamStatusMessage(), host);
        if (StreamInManager.isDone(host) && StorageService.instance.isBootstrapMode()) {
            StorageService.instance.removeBootstrapSource(host, pendingFile.getTable());
        }
    }
}

