/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.streaming.CompletedFileStatus;
import org.apache.cassandra.streaming.StreamOutManager;
import org.apache.log4j.Logger;

public class StreamFinishedVerbHandler
implements IVerbHandler {
    private static Logger logger = Logger.getLogger(StreamFinishedVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        byte[] body = message.getMessageBody();
        ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
        try {
            CompletedFileStatus streamStatus = CompletedFileStatus.serializer().deserialize(new DataInputStream(bufIn));
            switch (streamStatus.getAction()) {
                case DELETE: {
                    StreamOutManager.get(message.getFrom()).finishAndStartNext(streamStatus.getFile());
                    break;
                }
                case STREAM: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Need to re-stream file " + streamStatus.getFile()));
                    }
                    StreamOutManager.get(message.getFrom()).startNext();
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }
}

