/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamRequestMessage;
import org.apache.cassandra.streaming.StreamRequestMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StreamIn {
    private static Logger logger = Logger.getLogger(StreamOut.class);

    public static void requestRanges(InetAddress source, String tableName, Collection<Range> ranges) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requesting from " + source + " ranges " + StringUtils.join(ranges, (String)", ")));
        }
        StreamRequestMetadata streamRequestMetadata = new StreamRequestMetadata(FBUtilities.getLocalAddress(), ranges, tableName);
        Message message = StreamRequestMessage.makeStreamRequestMessage(new StreamRequestMessage(streamRequestMetadata));
        MessagingService.instance.sendOneWay(message, source);
    }
}

