/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.streaming.CompletedFileStatus;
import org.apache.cassandra.streaming.IStreamComplete;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.log4j.Logger;

class StreamInManager {
    private static final Logger logger = Logger.getLogger(StreamInManager.class);
    public static final Map<InetAddress, List<PendingFile>> ctxBag_ = new Hashtable<InetAddress, List<PendingFile>>();
    public static final Map<InetAddress, List<CompletedFileStatus>> streamStatusBag_ = new Hashtable<InetAddress, List<CompletedFileStatus>>();
    public static final Map<InetAddress, IStreamComplete> streamNotificationHandlers_ = new HashMap<InetAddress, IStreamComplete>();
    public static final Multimap<InetAddress, PendingFile> activeStreams = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    StreamInManager() {
    }

    public static synchronized PendingFile getStreamContext(InetAddress key) {
        List<PendingFile> context = ctxBag_.get(key);
        if (context == null) {
            throw new IllegalStateException("Streaming context has not been set for " + key);
        }
        PendingFile pendingFile = context.remove(0);
        if (context.isEmpty()) {
            ctxBag_.remove(key);
        }
        return pendingFile;
    }

    public static synchronized CompletedFileStatus getStreamStatus(InetAddress key) {
        List<CompletedFileStatus> status = streamStatusBag_.get(key);
        if (status == null) {
            throw new IllegalStateException("Streaming status has not been set for " + key);
        }
        CompletedFileStatus streamStatus = status.remove(0);
        if (status.isEmpty()) {
            streamStatusBag_.remove(key);
        }
        return streamStatus;
    }

    public static Set<InetAddress> getSources() {
        HashSet<InetAddress> set = new HashSet<InetAddress>();
        set.addAll(ctxBag_.keySet());
        set.addAll(activeStreams.keySet());
        return set;
    }

    public static List<PendingFile> getIncomingFiles(InetAddress host) {
        ArrayList<PendingFile> list = new ArrayList<PendingFile>();
        if (ctxBag_.containsKey(host)) {
            list.addAll((Collection)ctxBag_.get(host));
        }
        list.addAll(activeStreams.get((Object)host));
        return list;
    }

    public static synchronized boolean isDone(InetAddress key) {
        return ctxBag_.get(key) == null;
    }

    public static synchronized IStreamComplete getStreamCompletionHandler(InetAddress key) {
        return streamNotificationHandlers_.get(key);
    }

    public static synchronized void removeStreamCompletionHandler(InetAddress key) {
        streamNotificationHandlers_.remove(key);
    }

    public static synchronized void registerStreamCompletionHandler(InetAddress key, IStreamComplete streamComplete) {
        streamNotificationHandlers_.put(key, streamComplete);
    }

    public static synchronized void addStreamContext(InetAddress key, PendingFile pendingFile, CompletedFileStatus streamStatus) {
        List<PendingFile> context = ctxBag_.get(key);
        if (context == null) {
            context = new ArrayList<PendingFile>();
            ctxBag_.put(key, context);
        }
        context.add(pendingFile);
        List<CompletedFileStatus> status = streamStatusBag_.get(key);
        if (status == null) {
            status = new ArrayList<CompletedFileStatus>();
            streamStatusBag_.put(key, status);
        }
        status.add(streamStatus);
    }
}

