/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.utils.FBUtilities;

class StreamInitiateMessage {
    private static ICompactSerializer<StreamInitiateMessage> serializer_ = new StreamInitiateMessageSerializer();
    protected PendingFile[] streamContexts_ = new PendingFile[0];

    public static ICompactSerializer<StreamInitiateMessage> serializer() {
        return serializer_;
    }

    public static Message makeStreamInitiateMessage(StreamInitiateMessage biMessage) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        StreamInitiateMessage.serializer().serialize(biMessage, dos);
        return new Message(FBUtilities.getLocalAddress(), "", StorageService.Verb.STREAM_INITIATE, bos.toByteArray());
    }

    public StreamInitiateMessage(PendingFile[] pendingFiles) {
        this.streamContexts_ = pendingFiles;
    }

    public PendingFile[] getStreamContext() {
        return this.streamContexts_;
    }

    private static class StreamInitiateMessageSerializer
    implements ICompactSerializer<StreamInitiateMessage> {
        private StreamInitiateMessageSerializer() {
        }

        @Override
        public void serialize(StreamInitiateMessage bim, DataOutputStream dos) throws IOException {
            dos.writeInt(bim.streamContexts_.length);
            for (PendingFile pendingFile : bim.streamContexts_) {
                PendingFile.serializer().serialize(pendingFile, dos);
            }
        }

        @Override
        public StreamInitiateMessage deserialize(DataInputStream dis) throws IOException {
            int size = dis.readInt();
            PendingFile[] pendingFiles = new PendingFile[]{};
            if (size > 0) {
                pendingFiles = new PendingFile[size];
                for (int i = 0; i < size; ++i) {
                    pendingFiles[i] = PendingFile.serializer().deserialize(dis);
                }
            }
            return new StreamInitiateMessage(pendingFiles);
        }
    }
}

