/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.log4j.Logger;

public class StreamOutManager {
    private static Logger logger = Logger.getLogger(StreamOutManager.class);
    private static ConcurrentMap<InetAddress, StreamOutManager> streamManagers = new ConcurrentHashMap<InetAddress, StreamOutManager>();
    private final List<PendingFile> files = new ArrayList<PendingFile>();
    private final Map<String, PendingFile> fileMap = new HashMap<String, PendingFile>();
    private final InetAddress to;
    private long totalBytes = 0L;
    private final SimpleCondition condition = new SimpleCondition();

    public static StreamOutManager get(InetAddress to) {
        StreamOutManager possibleNew;
        StreamOutManager manager = (StreamOutManager)streamManagers.get(to);
        if (manager == null && (manager = streamManagers.putIfAbsent(to, possibleNew = new StreamOutManager(to))) == null) {
            manager = possibleNew;
        }
        return manager;
    }

    public static Set<InetAddress> getDestinations() {
        return new HashSet<InetAddress>(streamManagers.keySet());
    }

    private StreamOutManager(InetAddress to) {
        this.to = to;
    }

    public void addFilesToStream(PendingFile[] pendingFiles) {
        for (PendingFile pendingFile : pendingFiles) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding file " + pendingFile.getTargetFile() + " to be streamed."));
            }
            this.files.add(pendingFile);
            this.fileMap.put(pendingFile.getTargetFile(), pendingFile);
            this.totalBytes += pendingFile.getExpectedBytes();
        }
    }

    public void update(String path, long pos) {
        PendingFile pf = this.fileMap.get(path);
        if (pf != null) {
            pf.update(pos);
        }
    }

    public void startNext() {
        if (this.files.size() > 0) {
            File file = new File(this.files.get(0).getTargetFile());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Streaming " + file.length() + " length file " + file + " ..."));
            }
            MessagingService.instance.stream(file.getAbsolutePath(), 0L, file.length(), FBUtilities.getLocalAddress(), this.to);
        }
    }

    public void finishAndStartNext(String file) throws IOException {
        File f = new File(file);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting file " + file + " after streaming " + f.length() + "/" + this.totalBytes + " bytes."));
        }
        FileUtils.delete(file);
        PendingFile pf = this.files.remove(0);
        if (pf != null) {
            this.fileMap.remove(pf.getTargetFile());
        }
        if (this.files.size() > 0) {
            this.startNext();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Signalling that streaming is done for " + this.to));
            }
            this.condition.signalAll();
        }
    }

    public void waitForStreamCompletion() {
        try {
            this.condition.await();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    List<PendingFile> getFiles() {
        return Collections.unmodifiableList(this.files);
    }

    public class StreamFile
    extends File {
        private long ptr;

        public StreamFile(String path) {
            super(path);
            this.ptr = 0L;
            this.ptr = 0L;
        }

        private void update(long ptr) {
            this.ptr = ptr;
        }

        public long getPtr() {
            return this.ptr;
        }
    }
}

