/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.StreamRequestMetadata;
import org.apache.cassandra.utils.FBUtilities;

class StreamRequestMessage {
    private static ICompactSerializer<StreamRequestMessage> serializer_ = new StreamRequestMessageSerializer();
    protected StreamRequestMetadata[] streamRequestMetadata_ = new StreamRequestMetadata[0];

    protected static ICompactSerializer<StreamRequestMessage> serializer() {
        return serializer_;
    }

    protected static Message makeStreamRequestMessage(StreamRequestMessage streamRequestMessage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            StreamRequestMessage.serializer().serialize(streamRequestMessage, dos);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return new Message(FBUtilities.getLocalAddress(), "STREAM-STAGE", StorageService.Verb.STREAM_REQUEST, bos.toByteArray());
    }

    StreamRequestMessage(StreamRequestMetadata ... streamRequestMetadata) {
        assert (streamRequestMetadata != null);
        this.streamRequestMetadata_ = streamRequestMetadata;
    }

    private static class StreamRequestMessageSerializer
    implements ICompactSerializer<StreamRequestMessage> {
        private StreamRequestMessageSerializer() {
        }

        @Override
        public void serialize(StreamRequestMessage streamRequestMessage, DataOutputStream dos) throws IOException {
            StreamRequestMetadata[] streamRequestMetadata = streamRequestMessage.streamRequestMetadata_;
            dos.writeInt(streamRequestMetadata.length);
            for (StreamRequestMetadata bsmd : streamRequestMetadata) {
                StreamRequestMetadata.serializer().serialize(bsmd, dos);
            }
        }

        @Override
        public StreamRequestMessage deserialize(DataInputStream dis) throws IOException {
            int size = dis.readInt();
            StreamRequestMetadata[] streamRequestMetadata = new StreamRequestMetadata[size];
            for (int i = 0; i < size; ++i) {
                streamRequestMetadata[i] = StreamRequestMetadata.serializer().deserialize(dis);
            }
            return new StreamRequestMessage(streamRequestMetadata);
        }
    }
}

