/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.CompactEndPointSerializationHelper;
import org.apache.cassandra.streaming.StreamRequestMetadata;

class StreamRequestMetadataSerializer
implements ICompactSerializer<StreamRequestMetadata> {
    StreamRequestMetadataSerializer() {
    }

    @Override
    public void serialize(StreamRequestMetadata srMetadata, DataOutputStream dos) throws IOException {
        CompactEndPointSerializationHelper.serialize(srMetadata.target_, dos);
        dos.writeUTF(srMetadata.table_);
        dos.writeInt(srMetadata.ranges_.size());
        for (Range range : srMetadata.ranges_) {
            AbstractBounds.serializer().serialize(range, dos);
        }
    }

    @Override
    public StreamRequestMetadata deserialize(DataInputStream dis) throws IOException {
        InetAddress target = CompactEndPointSerializationHelper.deserialize(dis);
        String table = dis.readUTF();
        int size = dis.readInt();
        ArrayList<Range> ranges = size == 0 ? null : new ArrayList<Range>();
        for (int i = 0; i < size; ++i) {
            ranges.add((Range)AbstractBounds.serializer().deserialize(dis));
        }
        return new StreamRequestMetadata(target, ranges, table);
    }
}

