/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamRequestMessage;
import org.apache.cassandra.streaming.StreamRequestMetadata;
import org.apache.log4j.Logger;

public class StreamRequestVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(StreamRequestVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Received a StreamRequestMessage from " + message.getFrom()));
        }
        byte[] body = message.getMessageBody();
        ByteArrayInputStream bufIn = new ByteArrayInputStream(body);
        try {
            StreamRequestMetadata[] streamRequestMetadata;
            StreamRequestMessage streamRequestMessage = StreamRequestMessage.serializer().deserialize(new DataInputStream(bufIn));
            for (StreamRequestMetadata srm : streamRequestMetadata = streamRequestMessage.streamRequestMetadata_) {
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)srm.toString());
                }
                StreamOut.transferRanges(srm.target_, srm.table_, srm.ranges_, null);
            }
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }
}

