/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamInManager;
import org.apache.cassandra.streaming.StreamOutManager;
import org.apache.cassandra.streaming.StreamingServiceMBean;
import org.apache.log4j.Logger;

public class StreamingService
implements StreamingServiceMBean {
    private static final Logger logger = Logger.getLogger(StreamingService.class);
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.streaming:type=StreamingService";
    public static final StreamingService instance = new StreamingService();
    static final String NOTHING = "Nothing is happening";
    private String status = "Nothing is happening";

    private StreamingService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setStatus(String s) {
        assert (s != null);
        this.status = s;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Set<InetAddress> getStreamDestinations() {
        return StreamOutManager.getDestinations();
    }

    @Override
    public List<String> getOutgoingFiles(String host) throws IOException {
        InetAddress dest;
        ArrayList<String> files = new ArrayList<String>();
        Set<InetAddress> existingDestinations = this.getStreamDestinations();
        if (!existingDestinations.contains(dest = InetAddress.getByName(host))) {
            return files;
        }
        StreamOutManager manager = StreamOutManager.get(dest);
        for (PendingFile f : manager.getFiles()) {
            files.add(String.format("%s %d/%d", f.getTargetFile(), f.getPtr(), f.getExpectedBytes()));
        }
        return files;
    }

    @Override
    public Set<InetAddress> getStreamSources() {
        return StreamInManager.getSources();
    }

    @Override
    public List<String> getIncomingFiles(String host) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (PendingFile pf : StreamInManager.getIncomingFiles(InetAddress.getByName(host))) {
            files.add(String.format("%s: %s %d/%d", pf.getTable(), pf.getTargetFile(), pf.getPtr(), pf.getExpectedBytes()));
        }
        return files;
    }
}

