/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class CassandraDaemon {
    private static Logger logger = Logger.getLogger(CassandraDaemon.class);
    private TThreadPoolServer serverEngine;

    private void setup() throws IOException, TTransportException {
        TFramedTransport.Factory outTransportFactory;
        TFramedTransport.Factory inTransportFactory;
        String file = System.getProperty("storage-config") + File.separator + "log4j.properties";
        PropertyConfigurator.configure((String)file);
        int listenPort = DatabaseDescriptor.getThriftPort();
        InetAddress listenAddr = DatabaseDescriptor.getThriftAddress();
        if (listenAddr == null) {
            listenAddr = FBUtilities.getLocalAddress();
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error((Object)("Fatal exception in thread " + t), e);
                if (e instanceof OutOfMemoryError) {
                    System.exit(100);
                }
            }
        });
        for (String table : DatabaseDescriptor.getTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("opening keyspace " + table));
            }
            Table.open(table);
        }
        CommitLog.recover();
        CompactionManager.instance.checkAllColumnFamilies();
        StorageService.instance.initServer();
        CassandraServer cassandraServer = new CassandraServer();
        Cassandra.Processor processor = new Cassandra.Processor(cassandraServer);
        TServerSocket tServerSocket = new TServerSocket(new InetSocketAddress(listenAddr, listenPort));
        logger.info((Object)String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
        TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory();
        if (DatabaseDescriptor.isThriftFramed()) {
            inTransportFactory = new TFramedTransport.Factory();
            outTransportFactory = new TFramedTransport.Factory();
        } else {
            inTransportFactory = new TTransportFactory();
            outTransportFactory = new TTransportFactory();
        }
        TThreadPoolServer.Options options = new TThreadPoolServer.Options();
        options.minWorkerThreads = 64;
        this.serverEngine = new TThreadPoolServer(new TProcessorFactory((TProcessor)processor), (TServerTransport)tServerSocket, (TTransportFactory)inTransportFactory, (TTransportFactory)outTransportFactory, (TProtocolFactory)tProtocolFactory, (TProtocolFactory)tProtocolFactory, options);
    }

    public void init(String[] args) throws IOException, TTransportException {
        this.setup();
    }

    public void start() {
        logger.info((Object)"Cassandra starting up...");
        this.serverEngine.serve();
    }

    public void stop() {
        logger.info((Object)"Cassandra shutting down...");
        this.serverEngine.stop();
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        CassandraDaemon daemon = new CassandraDaemon();
        String pidFile = System.getProperty("cassandra-pidfile");
        try {
            daemon.setup();
            if (pidFile != null) {
                new File(pidFile).deleteOnExit();
            }
            if (System.getProperty("cassandra-foreground") == null) {
                System.out.close();
                System.err.close();
            }
            daemon.start();
        }
        catch (Throwable e) {
            String msg = "Exception encountered during startup.";
            logger.error((Object)msg, e);
            System.out.println(msg);
            e.printStackTrace();
            System.exit(3);
        }
    }
}

