/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.auth.AllowAllAuthenticator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.ThriftGlue;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.json.simple.JSONValue;

public class CassandraServer
implements Cassandra.Iface {
    public static String TOKEN_MAP = "token map";
    private static Logger logger = Logger.getLogger(CassandraServer.class);
    private static final List<ColumnOrSuperColumn> EMPTY_COLUMNS = Collections.emptyList();
    private static final List<Column> EMPTY_SUBCOLUMNS = Collections.emptyList();
    private ThreadLocal<Boolean> loginDone = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final StorageService storageService = StorageService.instance;

    protected Map<String, ColumnFamily> readColumnFamily(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows;
        HashMap<String, ColumnFamily> columnFamilyKeyMap = new HashMap<String, ColumnFamily>();
        if (consistency_level == ConsistencyLevel.ZERO) {
            throw new InvalidRequestException("Consistency level zero may not be applied to read operations");
        }
        if (consistency_level == ConsistencyLevel.ALL) {
            throw new InvalidRequestException("Consistency level all is not yet supported on read operations");
        }
        if (consistency_level == ConsistencyLevel.ANY) {
            throw new InvalidRequestException("Consistency level any may not be applied to read operations");
        }
        try {
            rows = StorageProxy.readProtocol(commands, consistency_level);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Row row : rows) {
            columnFamilyKeyMap.put(row.key, row.cf);
        }
        return columnFamilyKeyMap;
    }

    public List<Column> thriftifySubColumns(Collection<IColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return EMPTY_SUBCOLUMNS;
        }
        ArrayList<Column> thriftColumns = new ArrayList<Column>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column thrift_column = new Column(column.name(), column.value(), column.timestamp());
            thriftColumns.add(thrift_column);
        }
        return thriftColumns;
    }

    public List<ColumnOrSuperColumn> thriftifyColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            if (column.isMarkedForDelete()) continue;
            Column thrift_column = new Column(column.name(), column.value(), column.timestamp());
            thriftColumns.add(ThriftGlue.createColumnOrSuperColumn_Column(thrift_column));
        }
        if (reverseOrder) {
            Collections.reverse(thriftColumns);
        }
        return thriftColumns;
    }

    private List<ColumnOrSuperColumn> thriftifySuperColumns(Collection<IColumn> columns, boolean reverseOrder) {
        ArrayList<ColumnOrSuperColumn> thriftSuperColumns = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (IColumn column : columns) {
            List<Column> subcolumns = this.thriftifySubColumns(column.getSubColumns());
            if (subcolumns.isEmpty()) continue;
            SuperColumn superColumn = new SuperColumn(column.name(), subcolumns);
            thriftSuperColumns.add(ThriftGlue.createColumnOrSuperColumn_SuperColumn(superColumn));
        }
        if (reverseOrder) {
            Collections.reverse(thriftSuperColumns);
        }
        return thriftSuperColumns;
    }

    private Map<String, List<ColumnOrSuperColumn>> getSlice(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        Map<String, ColumnFamily> columnFamilies = this.readColumnFamily(commands, consistency_level);
        HashMap<String, List<ColumnOrSuperColumn>> columnFamiliesMap = new HashMap<String, List<ColumnOrSuperColumn>>();
        for (ReadCommand command : commands) {
            ColumnFamily cf = columnFamilies.get(command.key);
            boolean reverseOrder = command instanceof SliceFromReadCommand && ((SliceFromReadCommand)command).reversed;
            List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyColumnFamily(cf, command.queryPath.superColumnName != null, reverseOrder);
            columnFamiliesMap.put(command.key, thriftifiedColumns);
        }
        return columnFamiliesMap;
    }

    private List<ColumnOrSuperColumn> thriftifyColumnFamily(ColumnFamily cf, boolean subcolumnsOnly, boolean reverseOrder) {
        if (cf == null || cf.getColumnsMap().size() == 0) {
            return EMPTY_COLUMNS;
        }
        if (subcolumnsOnly) {
            IColumn column = cf.getColumnsMap().values().iterator().next();
            Collection<IColumn> subcolumns = column.getSubColumns();
            if (subcolumns == null || subcolumns.isEmpty()) {
                return EMPTY_COLUMNS;
            }
            return this.thriftifyColumns(subcolumns, reverseOrder);
        }
        if (cf.isSuper()) {
            return this.thriftifySuperColumns(cf.getSortedColumns(), reverseOrder);
        }
        return this.thriftifyColumns(cf.getSortedColumns(), reverseOrder);
    }

    @Override
    public List<ColumnOrSuperColumn> get_slice(String keyspace, String key, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get_slice");
        }
        this.checkLoginDone();
        return this.multigetSliceInternal(keyspace, Arrays.asList(key), column_parent, predicate, consistency_level).get(key);
    }

    @Override
    public Map<String, List<ColumnOrSuperColumn>> multiget_slice(String keyspace, List<String> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"multiget_slice");
        }
        this.checkLoginDone();
        return this.multigetSliceInternal(keyspace, keys, column_parent, predicate, consistency_level);
    }

    private Map<String, List<ColumnOrSuperColumn>> multigetSliceInternal(String keyspace, List<String> keys, ColumnParent column_parent, SlicePredicate predicate, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        ThriftValidation.validateColumnParent(keyspace, column_parent);
        ThriftValidation.validatePredicate(keyspace, column_parent, predicate);
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        if (predicate.column_names != null) {
            for (String key : keys) {
                ThriftValidation.validateKey(key);
                commands.add(new SliceByNamesReadCommand(keyspace, key, column_parent, predicate.column_names));
            }
        } else {
            SliceRange range = predicate.slice_range;
            for (String key : keys) {
                ThriftValidation.validateKey(key);
                commands.add(new SliceFromReadCommand(keyspace, key, column_parent, range.start, range.finish, range.reversed, range.count));
            }
        }
        return this.getSlice(commands, consistency_level);
    }

    @Override
    public ColumnOrSuperColumn get(String table, String key, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, NotFoundException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get");
        }
        this.checkLoginDone();
        ColumnOrSuperColumn column = this.multigetInternal(table, Arrays.asList(key), column_path, consistency_level).get(key);
        if (!column.isSetColumn() && !column.isSetSuper_column()) {
            throw new NotFoundException();
        }
        return column;
    }

    @Override
    public Map<String, ColumnOrSuperColumn> multiget(String table, List<String> keys, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"multiget");
        }
        this.checkLoginDone();
        return this.multigetInternal(table, keys, column_path, consistency_level);
    }

    private Map<String, ColumnOrSuperColumn> multigetInternal(String table, List<String> keys, ColumnPath column_path, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        ThriftValidation.validateColumnPath(table, column_path);
        QueryPath path = new QueryPath(column_path.column_family, column_path.column == null ? null : column_path.super_column);
        List<byte[]> nameAsList = Arrays.asList(new byte[][]{column_path.column == null ? column_path.super_column : column_path.column});
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>();
        for (String key : keys) {
            ThriftValidation.validateKey(key);
            commands.add(new SliceByNamesReadCommand(table, key, path, nameAsList));
        }
        HashMap<String, ColumnOrSuperColumn> columnFamiliesMap = new HashMap<String, ColumnOrSuperColumn>();
        Map<String, ColumnFamily> cfamilies = this.readColumnFamily(commands, consistency_level);
        for (ReadCommand command : commands) {
            ColumnFamily cf = cfamilies.get(command.key);
            if (cf == null) {
                columnFamiliesMap.put(command.key, new ColumnOrSuperColumn());
                continue;
            }
            List<ColumnOrSuperColumn> tcolumns = this.thriftifyColumnFamily(cf, command.queryPath.superColumnName != null, false);
            columnFamiliesMap.put(command.key, tcolumns.size() > 0 ? tcolumns.iterator().next() : new ColumnOrSuperColumn());
        }
        return columnFamiliesMap;
    }

    @Override
    public int get_count(String table, String key, ColumnParent column_parent, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"get_count");
        }
        this.checkLoginDone();
        SliceRange range = new SliceRange(ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.EMPTY_BYTE_ARRAY, false, Integer.MAX_VALUE);
        SlicePredicate predicate = new SlicePredicate().setSlice_range(range);
        return this.get_slice(table, key, column_parent, predicate, consistency_level).size();
    }

    @Override
    public void insert(String table, String key, ColumnPath column_path, byte[] value, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"insert");
        }
        this.checkLoginDone();
        ThriftValidation.validateKey(key);
        ThriftValidation.validateColumnPath(table, column_path);
        RowMutation rm = new RowMutation(table, key);
        try {
            rm.add(new QueryPath(column_path), value, timestamp);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        this.doInsert(consistency_level, rm);
    }

    @Override
    public void batch_insert(String keyspace, String key, Map<String, List<ColumnOrSuperColumn>> cfmap, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"batch_insert");
        }
        this.checkLoginDone();
        ThriftValidation.validateKey(key);
        for (String cfName : cfmap.keySet()) {
            for (ColumnOrSuperColumn cosc : cfmap.get(cfName)) {
                ThriftValidation.validateColumnOrSuperColumn(keyspace, cfName, cosc);
            }
        }
        this.doInsert(consistency_level, RowMutation.getRowMutation(keyspace, key, cfmap));
    }

    @Override
    public void batch_mutate(String keyspace, Map<String, Map<String, List<Mutation>>> mutation_map, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"batch_mutate");
        }
        this.checkLoginDone();
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        for (Map.Entry<String, Map<String, List<Mutation>>> mutationEntry : mutation_map.entrySet()) {
            String key = mutationEntry.getKey();
            ThriftValidation.validateKey(key);
            Map<String, List<Mutation>> columnFamilyToMutations = mutationEntry.getValue();
            for (Map.Entry<String, List<Mutation>> columnFamilyMutations : columnFamilyToMutations.entrySet()) {
                String cfName = columnFamilyMutations.getKey();
                for (Mutation mutation : columnFamilyMutations.getValue()) {
                    ThriftValidation.validateMutation(keyspace, cfName, mutation);
                }
            }
            rowMutations.add(RowMutation.getRowMutationFromMutations(keyspace, key, columnFamilyToMutations));
        }
        if (consistency_level == ConsistencyLevel.ZERO) {
            StorageProxy.mutate(rowMutations);
        } else {
            try {
                StorageProxy.mutateBlocking(rowMutations, consistency_level);
            }
            catch (TimeoutException e) {
                throw new TimedOutException();
            }
        }
    }

    @Override
    public void remove(String table, String key, ColumnPath column_path, long timestamp, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"remove");
        }
        this.checkLoginDone();
        ThriftValidation.validateKey(key);
        ThriftValidation.validateColumnPathOrParent(table, column_path);
        RowMutation rm = new RowMutation(table, key);
        rm.delete(new QueryPath(column_path), timestamp);
        this.doInsert(consistency_level, rm);
    }

    private void doInsert(ConsistencyLevel consistency_level, RowMutation rm) throws UnavailableException, TimedOutException {
        if (consistency_level != ConsistencyLevel.ZERO) {
            try {
                StorageProxy.mutateBlocking(Arrays.asList(rm), consistency_level);
            }
            catch (TimeoutException e) {
                throw new TimedOutException();
            }
        } else {
            StorageProxy.mutate(Arrays.asList(rm));
        }
    }

    @Override
    public String get_string_property(String propertyName) {
        if (propertyName.equals("cluster name")) {
            return DatabaseDescriptor.getClusterName();
        }
        if (propertyName.equals("config file")) {
            String filename = DatabaseDescriptor.getConfigFileName();
            try {
                int numRead;
                StringBuilder fileData = new StringBuilder(8192);
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
                byte[] buf = new byte[1024];
                while ((numRead = stream.read(buf)) != -1) {
                    String str = new String(buf, 0, numRead);
                    fileData.append(str);
                }
                stream.close();
                return fileData.toString();
            }
            catch (IOException e) {
                return "file not found!";
            }
        }
        if (propertyName.equals(TOKEN_MAP)) {
            return JSONValue.toJSONString(this.storageService.getStringEndpointMap());
        }
        if (propertyName.equals("version")) {
            return "2.1.0";
        }
        return "?";
    }

    @Override
    public List<String> get_string_list_property(String propertyName) {
        if (propertyName.equals("keyspaces")) {
            return new ArrayList<String>(DatabaseDescriptor.getTables());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Map<String, String>> describe_keyspace(String table) throws NotFoundException {
        HashMap<String, Map<String, String>> columnFamiliesMap = new HashMap<String, Map<String, String>>();
        Map<String, CFMetaData> tableMetaData = DatabaseDescriptor.getTableMetaData(table);
        if (tableMetaData == null) {
            throw new NotFoundException();
        }
        for (Map.Entry<String, CFMetaData> stringCFMetaDataEntry : tableMetaData.entrySet()) {
            CFMetaData columnFamilyMetaData = stringCFMetaDataEntry.getValue();
            HashMap<String, String> columnMap = new HashMap<String, String>();
            columnMap.put("Type", columnFamilyMetaData.columnType);
            columnMap.put("Desc", columnFamilyMetaData.comment == null ? columnFamilyMetaData.pretty() : columnFamilyMetaData.comment);
            columnMap.put("CompareWith", columnFamilyMetaData.comparator.getClass().getName());
            if (columnFamilyMetaData.columnType.equals("Super")) {
                columnMap.put("CompareSubcolumnsWith", columnFamilyMetaData.subcolumnComparator.getClass().getName());
            }
            columnFamiliesMap.put(columnFamilyMetaData.cfName, columnMap);
        }
        return columnFamiliesMap;
    }

    @Override
    public List<KeySlice> get_range_slice(String keyspace, ColumnParent column_parent, SlicePredicate predicate, String start_key, String finish_key, int maxRows, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("get_range_slice " + start_key + " to " + finish_key));
        }
        KeyRange range = new KeyRange().setStart_key(start_key).setEnd_key(finish_key).setCount(maxRows);
        return this.getRangeSlicesInternal(keyspace, column_parent, predicate, range, consistency_level);
    }

    @Override
    public List<KeySlice> get_range_slices(String keyspace, ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"range_slice");
        }
        return this.getRangeSlicesInternal(keyspace, column_parent, predicate, range, consistency_level);
    }

    private List<KeySlice> getRangeSlicesInternal(String keyspace, ColumnParent column_parent, SlicePredicate predicate, KeyRange range, ConsistencyLevel consistency_level) throws InvalidRequestException, UnavailableException, TimedOutException {
        List<Row> rows;
        this.checkLoginDone();
        ThriftValidation.validateColumnParent(keyspace, column_parent);
        ThriftValidation.validatePredicate(keyspace, column_parent, predicate);
        ThriftValidation.validateKeyRange(range);
        try {
            AbstractBounds bounds;
            IPartitioner p = StorageService.getPartitioner();
            if (range.start_key == null) {
                Token.TokenFactory tokenFactory = p.getTokenFactory();
                Token left = tokenFactory.fromString(range.start_token);
                Token right = tokenFactory.fromString(range.end_token);
                bounds = new Range(left, right);
            } else {
                bounds = new Bounds((Token)p.getToken(range.start_key), (Token)p.getToken(range.end_key));
            }
            rows = StorageProxy.getRangeSlice(new RangeSliceCommand(keyspace, column_parent, predicate, bounds, range.count), consistency_level);
            assert (rows != null);
        }
        catch (TimeoutException e) {
            throw new TimedOutException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<KeySlice> keySlices = new ArrayList<KeySlice>(rows.size());
        boolean reversed = predicate.slice_range != null && predicate.slice_range.reversed;
        for (Row row : rows) {
            List<ColumnOrSuperColumn> thriftifiedColumns = this.thriftifyColumnFamily(row.cf, column_parent.super_column != null, reversed);
            keySlices.add(new KeySlice(row.key, thriftifiedColumns));
        }
        return keySlices;
    }

    @Override
    public Set<String> describe_keyspaces() throws TException {
        return DatabaseDescriptor.getTables();
    }

    @Override
    public String describe_cluster_name() throws TException {
        return DatabaseDescriptor.getClusterName();
    }

    @Override
    public String describe_version() throws TException {
        return "2.1.0";
    }

    @Override
    public List<TokenRange> describe_ring(String keyspace) {
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        for (Map.Entry<Range, List<String>> entry : StorageService.instance.getRangeToEndPointMap(keyspace).entrySet()) {
            Range range = entry.getKey();
            List<String> endpoints = entry.getValue();
            ranges.add(new TokenRange(range.left.toString(), range.right.toString(), endpoints));
        }
        return ranges;
    }

    @Override
    public List<String> describe_splits(String start_token, String end_token, int keys_per_split) throws TException {
        Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
        List<Token> tokens = StorageService.instance.getSplits(new Range(tf.fromString(start_token), tf.fromString(end_token)), keys_per_split);
        ArrayList<String> splits = new ArrayList<String>(tokens.size());
        for (Token token : tokens) {
            splits.add(token.toString());
        }
        return splits;
    }

    @Override
    public void login(String keyspace, AuthenticationRequest auth_request) throws AuthenticationException, AuthorizationException, TException {
        DatabaseDescriptor.getAuthenticator().login(keyspace, auth_request);
        this.loginDone.set(true);
    }

    protected void checkLoginDone() throws InvalidRequestException {
        if (DatabaseDescriptor.getAuthenticator() instanceof AllowAllAuthenticator) {
            return;
        }
        if (!this.loginDone.get().booleanValue()) {
            throw new InvalidRequestException("Login is required before any other API calls");
        }
    }
}

