/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class KeySlice
implements TBase<_Fields>,
Serializable,
Cloneable,
Comparable<KeySlice> {
    private static final TStruct STRUCT_DESC = new TStruct("KeySlice");
    private static final TField KEY_FIELD_DESC = new TField("key", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    public String key;
    public List<ColumnOrSuperColumn> columns;
    public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class){
        {
            this.put(_Fields.KEY, new FieldMetaData("key", 1, new FieldValueMetaData(11)));
            this.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnOrSuperColumn.class))));
        }
    });

    public KeySlice() {
    }

    public KeySlice(String key, List<ColumnOrSuperColumn> columns) {
        this();
        this.key = key;
        this.columns = columns;
    }

    public KeySlice(KeySlice other) {
        if (other.isSetKey()) {
            this.key = other.key;
        }
        if (other.isSetColumns()) {
            ArrayList<ColumnOrSuperColumn> __this__columns = new ArrayList<ColumnOrSuperColumn>();
            for (ColumnOrSuperColumn other_element : other.columns) {
                __this__columns.add(new ColumnOrSuperColumn(other_element));
            }
            this.columns = __this__columns;
        }
    }

    public KeySlice deepCopy() {
        return new KeySlice(this);
    }

    @Deprecated
    public KeySlice clone() {
        return new KeySlice(this);
    }

    public String getKey() {
        return this.key;
    }

    public KeySlice setKey(String key) {
        this.key = key;
        return this;
    }

    public void unsetKey() {
        this.key = null;
    }

    public boolean isSetKey() {
        return this.key != null;
    }

    public void setKeyIsSet(boolean value) {
        if (!value) {
            this.key = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<ColumnOrSuperColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(ColumnOrSuperColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnOrSuperColumn>();
        }
        this.columns.add(elem);
    }

    public List<ColumnOrSuperColumn> getColumns() {
        return this.columns;
    }

    public KeySlice setColumns(List<ColumnOrSuperColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case KEY: {
                if (value == null) {
                    this.unsetKey();
                    break;
                }
                this.setKey((String)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
            }
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        this.setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case KEY: {
                return this.getKey();
            }
            case COLUMNS: {
                return this.getColumns();
            }
        }
        throw new IllegalStateException();
    }

    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
    }

    public boolean isSet(_Fields field) {
        switch (field) {
            case KEY: {
                return this.isSetKey();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(int fieldID) {
        return this.isSet(_Fields.findByThriftIdOrThrow(fieldID));
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof KeySlice) {
            return this.equals((KeySlice)that);
        }
        return false;
    }

    public boolean equals(KeySlice that) {
        if (that == null) {
            return false;
        }
        boolean this_present_key = this.isSetKey();
        boolean that_present_key = that.isSetKey();
        if (this_present_key || that_present_key) {
            if (!this_present_key || !that_present_key) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(KeySlice other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        KeySlice typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetKey()).compareTo(typedOther.isSetKey());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKey() && (lastComparison = TBaseHelper.compareTo((String)this.key, (String)typedOther.key)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.key = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list8 = iprot.readListBegin();
                        this.columns = new ArrayList<ColumnOrSuperColumn>(_list8.size);
                        for (int _i9 = 0; _i9 < _list8.size; ++_i9) {
                            ColumnOrSuperColumn _elem10 = new ColumnOrSuperColumn();
                            _elem10.read(iprot);
                            this.columns.add(_elem10);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.key != null) {
            oprot.writeFieldBegin(KEY_FIELD_DESC);
            oprot.writeString(this.key);
            oprot.writeFieldEnd();
        }
        if (this.columns != null) {
            oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.columns.size()));
            for (ColumnOrSuperColumn _iter11 : this.columns) {
                _iter11.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeySlice(");
        boolean first = true;
        sb.append("key:");
        if (this.key == null) {
            sb.append("null");
        } else {
            sb.append(this.key);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.key == null) {
            throw new TProtocolException("Required field 'key' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(KeySlice.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        KEY(1, "key"),
        COLUMNS(2, "columns");

        private static final Map<Integer, _Fields> byId;
        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            return byId.get(fieldId);
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byId = new HashMap<Integer, _Fields>();
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byId.put(Integer.valueOf(field._thriftId), field);
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

