/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class SuperColumn
implements TBase<_Fields>,
Serializable,
Cloneable,
Comparable<SuperColumn> {
    private static final TStruct STRUCT_DESC = new TStruct("SuperColumn");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 2);
    public byte[] name;
    public List<Column> columns;
    public static final Map<_Fields, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new EnumMap<_Fields, FieldMetaData>(_Fields.class){
        {
            this.put(_Fields.NAME, new FieldMetaData("name", 1, new FieldValueMetaData(11)));
            this.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Column.class))));
        }
    });

    public SuperColumn() {
    }

    public SuperColumn(byte[] name, List<Column> columns) {
        this();
        this.name = name;
        this.columns = columns;
    }

    public SuperColumn(SuperColumn other) {
        if (other.isSetName()) {
            this.name = new byte[other.name.length];
            System.arraycopy(other.name, 0, this.name, 0, other.name.length);
        }
        if (other.isSetColumns()) {
            ArrayList<Column> __this__columns = new ArrayList<Column>();
            for (Column other_element : other.columns) {
                __this__columns.add(new Column(other_element));
            }
            this.columns = __this__columns;
        }
    }

    public SuperColumn deepCopy() {
        return new SuperColumn(this);
    }

    @Deprecated
    public SuperColumn clone() {
        return new SuperColumn(this);
    }

    public byte[] getName() {
        return this.name;
    }

    public SuperColumn setName(byte[] name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    public Iterator<Column> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(Column elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(elem);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public SuperColumn setColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((byte[])value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
            }
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        this.setFieldValue(_Fields.findByThriftIdOrThrow(fieldID), value);
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case COLUMNS: {
                return this.getColumns();
            }
        }
        throw new IllegalStateException();
    }

    public Object getFieldValue(int fieldId) {
        return this.getFieldValue(_Fields.findByThriftIdOrThrow(fieldId));
    }

    public boolean isSet(_Fields field) {
        switch (field) {
            case NAME: {
                return this.isSetName();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(int fieldID) {
        return this.isSet(_Fields.findByThriftIdOrThrow(fieldID));
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof SuperColumn) {
            return this.equals((SuperColumn)that);
        }
        return false;
    }

    public boolean equals(SuperColumn that) {
        if (that == null) {
            return false;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!Arrays.equals(this.name, that.name)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!((Object)this.columns).equals(that.columns)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(SuperColumn other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        SuperColumn typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(typedOther.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((byte[])this.name, (byte[])typedOther.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(typedOther.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, typedOther.columns)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.columns = new ArrayList<Column>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            Column _elem2 = new Column();
                            _elem2.read(iprot);
                            this.columns.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.name != null) {
            oprot.writeFieldBegin(NAME_FIELD_DESC);
            oprot.writeBinary(this.name);
            oprot.writeFieldEnd();
        }
        if (this.columns != null) {
            oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.columns.size()));
            for (Column _iter3 : this.columns) {
                _iter3.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SuperColumn(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            int __name_size = Math.min(this.name.length, 128);
            for (int i = 0; i < __name_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.name[i]).length() > 1 ? Integer.toHexString(this.name[i]).substring(Integer.toHexString(this.name[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.name[i]).toUpperCase());
            }
            if (this.name.length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.name == null) {
            throw new TProtocolException("Required field 'name' was not present! Struct: " + this.toString());
        }
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(SuperColumn.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        COLUMNS(2, "columns");

        private static final Map<Integer, _Fields> byId;
        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            return byId.get(fieldId);
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byId = new HashMap<Integer, _Fields>();
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byId.put(Integer.valueOf(field._thriftId), field);
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

