/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.MemoryUsage;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.cache.JMXInstrumentedCacheMBean;
import org.apache.cassandra.concurrent.IExecutorMBean;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class NodeCmd {
    private static final String HOST_OPT_LONG = "host";
    private static final String HOST_OPT_SHORT = "h";
    private static final String PORT_OPT_LONG = "port";
    private static final String PORT_OPT_SHORT = "p";
    private static final int defaultPort = 8080;
    private static Options options = null;
    private NodeProbe probe;

    public NodeCmd(NodeProbe probe) {
        this.probe = probe;
    }

    private static void printUsage() {
        HelpFormatter hf = new HelpFormatter();
        String header = String.format("%nAvailable commands: ring, info, cleanup, compact, cfstats, snapshot [snapshotname], clearsnapshot, tpstats, flush, drain, repair, decommission, move, loadbalance, removetoken, setcachecapacity <keyspace> <cfname> <keycachecapacity> <rowcachecapacity>, getcompactionthreshold, setcompactionthreshold [minthreshold] ([maxthreshold])streams [host]", new Object[0]);
        String usage = String.format("java %s --host <arg> <command>%n", NodeCmd.class.getName());
        hf.printHelp(usage, "", options, header);
    }

    public void printRing(PrintStream outs) {
        Map<Range, List<String>> rangeMap = this.probe.getRangeToEndPointMap(null);
        ArrayList<Range> ranges = new ArrayList<Range>(rangeMap.keySet());
        Collections.sort(ranges);
        Set<String> liveNodes = this.probe.getLiveNodes();
        Set<String> deadNodes = this.probe.getUnreachableNodes();
        Map<String, String> loadMap = this.probe.getLoadMap();
        int counter = 0;
        outs.print(String.format("%-14s", "Address"));
        outs.print(String.format("%-11s", "Status"));
        outs.print(String.format("%-14s", "Load"));
        outs.print(String.format("%-43s", "Range"));
        outs.println("Ring");
        if (ranges.size() > 1) {
            outs.println(String.format("%-14s%-11s%-14s%-43s", "", "", "", ((Range)ranges.get((int)0)).left));
        }
        for (Range range : ranges) {
            List<String> endpoints = rangeMap.get(range);
            String primaryEndpoint = endpoints.get(0);
            outs.print(String.format("%-14s", primaryEndpoint));
            String status = liveNodes.contains(primaryEndpoint) ? "Up" : (deadNodes.contains(primaryEndpoint) ? "Down" : "?");
            outs.print(String.format("%-11s", status));
            String load = loadMap.containsKey(primaryEndpoint) ? loadMap.get(primaryEndpoint) : "?";
            outs.print(String.format("%-14s", load));
            outs.print(String.format("%-43s", range.right));
            String asciiRingArt = counter == 0 ? "|<--|" : (counter == rangeMap.size() - 1 ? "|-->|" : (rangeMap.size() > 4 && counter % 2 == 0 ? "v   |" : (rangeMap.size() > 4 && counter % 2 != 0 ? "|   ^" : "|   |")));
            outs.println(asciiRingArt);
            ++counter;
        }
    }

    public void printThreadPoolStats(PrintStream outs) {
        outs.print(String.format("%-25s", "Pool Name"));
        outs.print(String.format("%10s", "Active"));
        outs.print(String.format("%10s", "Pending"));
        outs.print(String.format("%15s", "Completed"));
        outs.println();
        Iterator<Map.Entry<String, IExecutorMBean>> threads = this.probe.getThreadPoolMBeanProxies();
        while (threads.hasNext()) {
            Map.Entry<String, IExecutorMBean> thread = threads.next();
            String poolName = thread.getKey();
            IExecutorMBean threadPoolProxy = thread.getValue();
            outs.print(String.format("%-25s", poolName));
            outs.print(String.format("%10d", threadPoolProxy.getActiveCount()));
            outs.print(String.format("%10d", threadPoolProxy.getPendingTasks()));
            outs.print(String.format("%15d", threadPoolProxy.getCompletedTasks()));
            outs.println();
        }
    }

    public void printInfo(PrintStream outs) {
        outs.println(this.probe.getToken());
        outs.println(String.format("%-17s: %s", "Load", this.probe.getLoadString()));
        outs.println(String.format("%-17s: %s", "Generation No", this.probe.getCurrentGenerationNumber()));
        long secondsUp = this.probe.getUptime() / 1000L;
        outs.println(String.format("%-17s: %d", "Uptime (seconds)", secondsUp));
        MemoryUsage heapUsage = this.probe.getHeapMemoryUsage();
        double memUsed = (double)heapUsage.getUsed() / 1048576.0;
        double memMax = (double)heapUsage.getMax() / 1048576.0;
        outs.println(String.format("%-17s: %.2f / %.2f", "Heap Memory (MB)", memUsed, memMax));
    }

    public void printStreamInfo(final InetAddress addr, PrintStream outs) {
        List<String> files;
        Set<InetAddress> hosts;
        outs.println(String.format("Mode: %s", this.probe.getOperationMode()));
        Set<InetAddress> set = hosts = addr == null ? this.probe.getStreamDestinations() : new HashSet<InetAddress>(){
            {
                this.add(addr);
            }
        };
        if (hosts.size() == 0) {
            outs.println("Not sending any streams.");
        }
        for (InetAddress host : hosts) {
            try {
                files = this.probe.getFilesDestinedFor(host);
                if (files.size() > 0) {
                    outs.println(String.format("Streaming to: %s", host));
                    for (String file : files) {
                        outs.println(String.format("   %s", file));
                    }
                    continue;
                }
                outs.println(String.format(" Nothing streaming to %s", host));
            }
            catch (IOException ex) {
                outs.println(String.format("   Error retrieving file data for %s", host));
            }
        }
        Set<InetAddress> set2 = hosts = addr == null ? this.probe.getStreamSources() : new HashSet<InetAddress>(){
            {
                this.add(addr);
            }
        };
        if (hosts.size() == 0) {
            outs.println("Not receiving any streams.");
        }
        for (InetAddress host : hosts) {
            try {
                files = this.probe.getIncomingFiles(host);
                if (files.size() > 0) {
                    outs.println(String.format("Streaming from: %s", host));
                    for (String file : files) {
                        outs.println(String.format("   %s", file));
                    }
                    continue;
                }
                outs.println(String.format(" Nothing streaming from %s", host));
            }
            catch (IOException ex) {
                outs.println(String.format("   Error retrieving file data for %s", host));
            }
        }
    }

    public void printColumnFamilyStats(PrintStream outs) {
        ArrayList<ColumnFamilyStoreMBean> columnFamilies;
        HashMap cfstoreMap = new HashMap();
        Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> cfamilies = this.probe.getColumnFamilyStoreMBeanProxies();
        while (cfamilies.hasNext()) {
            Map.Entry<String, ColumnFamilyStoreMBean> entry = cfamilies.next();
            String tableName = entry.getKey();
            ColumnFamilyStoreMBean cfsProxy = entry.getValue();
            if (!cfstoreMap.containsKey(tableName)) {
                columnFamilies = new ArrayList<ColumnFamilyStoreMBean>();
                columnFamilies.add(cfsProxy);
                cfstoreMap.put(tableName, columnFamilies);
                continue;
            }
            ((List)cfstoreMap.get(tableName)).add(cfsProxy);
        }
        for (Map.Entry entry : cfstoreMap.entrySet()) {
            String tableName = (String)entry.getKey();
            columnFamilies = (ArrayList<ColumnFamilyStoreMBean>)entry.getValue();
            int tableReadCount = 0;
            int tableWriteCount = 0;
            int tablePendingTasks = 0;
            double tableTotalReadTime = 0.0;
            double tableTotalWriteTime = 0.0;
            outs.println("Keyspace: " + tableName);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                long writeCount = cfstore.getWriteCount();
                long readCount = cfstore.getReadCount();
                if (readCount > 0L) {
                    tableReadCount = (int)((long)tableReadCount + readCount);
                    tableTotalReadTime += (double)cfstore.getTotalReadLatencyMicros();
                }
                if (writeCount > 0L) {
                    tableWriteCount = (int)((long)tableWriteCount + writeCount);
                    tableTotalWriteTime += (double)cfstore.getTotalWriteLatencyMicros();
                }
                tablePendingTasks += cfstore.getPendingTasks();
            }
            double tableReadLatency = tableReadCount > 0 ? tableTotalReadTime / (double)tableReadCount / 1000.0 : Double.NaN;
            double tableWriteLatency = tableWriteCount > 0 ? tableTotalWriteTime / (double)tableWriteCount / 1000.0 : Double.NaN;
            outs.println("\tRead Count: " + tableReadCount);
            outs.println("\tRead Latency: " + String.format("%s", tableReadLatency) + " ms.");
            outs.println("\tWrite Count: " + tableWriteCount);
            outs.println("\tWrite Latency: " + String.format("%s", tableWriteLatency) + " ms.");
            outs.println("\tPending Tasks: " + tablePendingTasks);
            for (ColumnFamilyStoreMBean cfstore : columnFamilies) {
                outs.println("\t\tColumn Family: " + cfstore.getColumnFamilyName());
                outs.println("\t\tSSTable count: " + cfstore.getLiveSSTableCount());
                outs.println("\t\tSpace used (live): " + cfstore.getLiveDiskSpaceUsed());
                outs.println("\t\tSpace used (total): " + cfstore.getTotalDiskSpaceUsed());
                outs.println("\t\tMemtable Columns Count: " + cfstore.getMemtableColumnsCount());
                outs.println("\t\tMemtable Data Size: " + cfstore.getMemtableDataSize());
                outs.println("\t\tMemtable Switch Count: " + cfstore.getMemtableSwitchCount());
                outs.println("\t\tRead Count: " + cfstore.getReadCount());
                outs.println("\t\tRead Latency: " + String.format("%01.3f", cfstore.getRecentReadLatencyMicros() / 1000.0) + " ms.");
                outs.println("\t\tWrite Count: " + cfstore.getWriteCount());
                outs.println("\t\tWrite Latency: " + String.format("%01.3f", cfstore.getRecentWriteLatencyMicros() / 1000.0) + " ms.");
                outs.println("\t\tPending Tasks: " + cfstore.getPendingTasks());
                JMXInstrumentedCacheMBean keyCacheMBean = this.probe.getKeyCacheMBean(tableName, cfstore.getColumnFamilyName());
                if (keyCacheMBean.getCapacity() > 0) {
                    outs.println("\t\tKey cache capacity: " + keyCacheMBean.getCapacity());
                    outs.println("\t\tKey cache size: " + keyCacheMBean.getSize());
                    outs.println("\t\tKey cache hit rate: " + keyCacheMBean.getRecentHitRate());
                } else {
                    outs.println("\t\tKey cache: disabled");
                }
                JMXInstrumentedCacheMBean rowCacheMBean = this.probe.getRowCacheMBean(tableName, cfstore.getColumnFamilyName());
                if (rowCacheMBean.getCapacity() > 0) {
                    outs.println("\t\tRow cache capacity: " + rowCacheMBean.getCapacity());
                    outs.println("\t\tRow cache size: " + rowCacheMBean.getSize());
                    outs.println("\t\tRow cache hit rate: " + rowCacheMBean.getRecentHitRate());
                } else {
                    outs.println("\t\tRow cache: disabled");
                }
                outs.println("\t\tCompacted row minimum size: " + cfstore.getMinRowCompactedSize());
                outs.println("\t\tCompacted row maximum size: " + cfstore.getMaxRowCompactedSize());
                outs.println("\t\tCompacted row mean size: " + cfstore.getMeanRowCompactedSize());
                outs.println("");
            }
            outs.println("----------------");
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException parseExcep) {
            System.err.println((Object)parseExcep);
            NodeCmd.printUsage();
            System.exit(1);
        }
        String host = cmd.getOptionValue(HOST_OPT_LONG);
        int port = 8080;
        String portNum = cmd.getOptionValue(PORT_OPT_LONG);
        if (portNum != null) {
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Port must be a number");
            }
        }
        NodeProbe probe = null;
        try {
            probe = new NodeProbe(host, port);
        }
        catch (IOException ioe) {
            System.err.println("Error connecting to remote JMX agent!");
            ioe.printStackTrace();
            System.exit(3);
        }
        if (cmd.getArgs().length < 1) {
            System.err.println("Missing argument for command.");
            NodeCmd.printUsage();
            System.exit(1);
        }
        NodeCmd nodeCmd = new NodeCmd(probe);
        String[] arguments = cmd.getArgs();
        String cmdName = arguments[0];
        if (cmdName.equals("ring")) {
            nodeCmd.printRing(System.out);
        } else if (cmdName.equals("info")) {
            nodeCmd.printInfo(System.out);
        } else if (cmdName.equals("cleanup")) {
            probe.forceTableCleanup();
        } else if (cmdName.equals("compact")) {
            probe.forceTableCompaction();
        } else if (cmdName.equals("cfstats")) {
            nodeCmd.printColumnFamilyStats(System.out);
        } else if (cmdName.equals("decommission")) {
            probe.decommission();
        } else if (cmdName.equals("loadbalance")) {
            probe.loadBalance();
        } else if (cmdName.equals("move")) {
            if (arguments.length <= 1) {
                System.err.println("missing token argument");
            }
            probe.move(arguments[1]);
        } else if (cmdName.equals("removetoken")) {
            if (arguments.length <= 1) {
                System.err.println("missing token argument");
            }
            probe.removeToken(arguments[1]);
        } else if (cmdName.equals("snapshot")) {
            String snapshotName = "";
            if (arguments.length > 1) {
                snapshotName = arguments[1];
            }
            probe.takeSnapshot(snapshotName);
        } else if (cmdName.equals("clearsnapshot")) {
            probe.clearSnapshot();
        } else if (cmdName.equals("tpstats")) {
            nodeCmd.printThreadPoolStats(System.out);
        } else if (cmdName.equals("flush") || cmdName.equals("repair")) {
            if (cmd.getArgs().length < 2) {
                System.err.println("Missing keyspace argument.");
                NodeCmd.printUsage();
                System.exit(1);
            }
            String[] columnFamilies = new String[cmd.getArgs().length - 2];
            for (int i = 0; i < columnFamilies.length; ++i) {
                columnFamilies[i] = cmd.getArgs()[i + 2];
            }
            if (cmdName.equals("flush")) {
                probe.forceTableFlush(cmd.getArgs()[1], columnFamilies);
            } else {
                probe.forceTableRepair(cmd.getArgs()[1], columnFamilies);
            }
        } else if (cmdName.equals("drain")) {
            try {
                probe.drain();
            }
            catch (ExecutionException ee) {
                System.err.println("Error occured during flushing");
                ee.printStackTrace();
                System.exit(3);
            }
        } else if (cmdName.equals("setcachecapacity")) {
            if (cmd.getArgs().length != 5) {
                System.err.println("cacheinfo requires keyspace and column family name arguments, followed by key cache capacity and row cache capacity, in rows");
            }
            String tableName = cmd.getArgs()[1];
            String cfName = cmd.getArgs()[2];
            int keyCacheCapacity = Integer.valueOf(cmd.getArgs()[3]);
            int rowCacheCapacity = Integer.valueOf(cmd.getArgs()[4]);
            probe.setCacheCapacities(tableName, cfName, keyCacheCapacity, rowCacheCapacity);
        } else if (cmdName.equals("getcompactionthreshold")) {
            probe.getCompactionThreshold(System.out);
        } else if (cmdName.equals("setcompactionthreshold")) {
            if (arguments.length < 2) {
                System.err.println("Missing threshold value(s)");
                NodeCmd.printUsage();
                System.exit(1);
            }
            int minthreshold = Integer.parseInt(arguments[1]);
            int maxthreshold = CompactionManager.instance.getMaximumCompactionThreshold();
            if (arguments.length > 2) {
                maxthreshold = Integer.parseInt(arguments[2]);
            }
            if (minthreshold > maxthreshold) {
                System.err.println("Min threshold can't be greater than Max threshold");
                NodeCmd.printUsage();
                System.exit(1);
            }
            if (minthreshold < 2 && maxthreshold != 0) {
                System.err.println("Min threshold must be at least 2");
                NodeCmd.printUsage();
                System.exit(1);
            }
            probe.setCompactionThreshold(minthreshold, maxthreshold);
        } else if (cmdName.equals("streams")) {
            String otherHost = arguments.length > 1 ? arguments[1] : null;
            nodeCmd.printStreamInfo(otherHost == null ? null : InetAddress.getByName(otherHost), System.out);
        } else {
            System.err.println("Unrecognized command: " + cmdName + ".");
            NodeCmd.printUsage();
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        options = new Options();
        Option optHost = new Option(HOST_OPT_SHORT, HOST_OPT_LONG, true, "node hostname or ip address");
        optHost.setRequired(true);
        options.addOption(optHost);
        options.addOption(PORT_OPT_SHORT, PORT_OPT_LONG, true, "remote jmx agent port number");
    }
}

