/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cassandra.cache.JMXInstrumentedCacheMBean;
import org.apache.cassandra.concurrent.IExecutorMBean;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CompactionManagerMBean;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.StreamingServiceMBean;
import org.apache.cassandra.tools.ColumnFamilyStoreMBeanIterator;
import org.apache.cassandra.tools.ThreadPoolProxyMBeanIterator;

public class NodeProbe {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final String ssObjName = "org.apache.cassandra.service:type=StorageService";
    private static final int defaultPort = 8080;
    private String host;
    private int port;
    private MBeanServerConnection mbeanServerConn;
    private StorageServiceMBean ssProxy;
    private MemoryMXBean memProxy;
    private RuntimeMXBean runtimeProxy;
    private CompactionManagerMBean mcmProxy;
    private StreamingServiceMBean streamProxy;

    public NodeProbe(String host, int port) throws IOException, InterruptedException {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public NodeProbe(String host) throws IOException, InterruptedException {
        this.host = host;
        this.port = 8080;
        this.connect();
    }

    private void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, this.host, this.port));
        JMXConnector jmxc = JMXConnectorFactory.connect(jmxUrl, null);
        this.mbeanServerConn = jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(ssObjName);
            this.ssProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=CompactionManager");
            this.mcmProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, CompactionManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.streaming:type=StreamingService");
            this.streamProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StreamingServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        this.memProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
        this.runtimeProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public void forceTableCleanup() throws IOException {
        this.ssProxy.forceTableCleanup();
    }

    public void forceTableCompaction() throws IOException {
        this.ssProxy.forceTableCompaction();
    }

    public void forceTableFlush(String tableName, String ... columnFamilies) throws IOException {
        this.ssProxy.forceTableFlush(tableName, columnFamilies);
    }

    public void forceTableRepair(String tableName, String ... columnFamilies) throws IOException {
        this.ssProxy.forceTableRepair(tableName, columnFamilies);
    }

    public void drain() throws IOException, InterruptedException, ExecutionException {
        this.ssProxy.drain();
    }

    public Map<Range, List<String>> getRangeToEndPointMap(String tableName) {
        return this.ssProxy.getRangeToEndPointMap(tableName);
    }

    public Set<String> getLiveNodes() {
        return this.ssProxy.getLiveNodes();
    }

    public void printRing(PrintStream outs) {
        Map<Range, List<String>> rangeMap = this.ssProxy.getRangeToEndPointMap(null);
        ArrayList<Range> ranges = new ArrayList<Range>(rangeMap.keySet());
        Collections.sort(ranges);
        Set<String> liveNodes = this.ssProxy.getLiveNodes();
        Set<String> deadNodes = this.ssProxy.getUnreachableNodes();
        Map<String, String> loadMap = this.ssProxy.getLoadMap();
        int counter = 0;
        outs.print(String.format("%-14s", "Address"));
        outs.print(String.format("%-11s", "Status"));
        outs.print(String.format("%-14s", "Load"));
        outs.print(String.format("%-43s", "Range"));
        outs.println("Ring");
        if (ranges.size() > 1) {
            outs.println(String.format("%-14s%-11s%-14s%-43s", "", "", "", ((Range)ranges.get((int)0)).left));
        }
        for (Range range : ranges) {
            List<String> endpoints = rangeMap.get(range);
            String primaryEndpoint = endpoints.get(0);
            outs.print(String.format("%-14s", primaryEndpoint));
            String status = liveNodes.contains(primaryEndpoint) ? "Up" : (deadNodes.contains(primaryEndpoint) ? "Down" : "?");
            outs.print(String.format("%-11s", status));
            String load = loadMap.containsKey(primaryEndpoint) ? loadMap.get(primaryEndpoint) : "?";
            outs.print(String.format("%-14s", load));
            outs.print(String.format("%-43s", range.right));
            String asciiRingArt = counter == 0 ? "|<--|" : (counter == rangeMap.size() - 1 ? "|-->|" : (rangeMap.size() > 4 && counter % 2 == 0 ? "v   |" : (rangeMap.size() > 4 && counter % 2 != 0 ? "|   ^" : "|   |")));
            outs.println(asciiRingArt);
            ++counter;
        }
    }

    public Set<String> getUnreachableNodes() {
        return this.ssProxy.getUnreachableNodes();
    }

    public Map<String, String> getLoadMap() {
        return this.ssProxy.getLoadMap();
    }

    public Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> getColumnFamilyStoreMBeanProxies() {
        try {
            return new ColumnFamilyStoreMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public JMXInstrumentedCacheMBean getKeyCacheMBean(String tableName, String cfName) {
        String keyCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "KeyCache";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(keyCachePath), JMXInstrumentedCacheMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public JMXInstrumentedCacheMBean getRowCacheMBean(String tableName, String cfName) {
        String rowCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "RowCache";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(rowCachePath), JMXInstrumentedCacheMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public String getToken() {
        return this.ssProxy.getToken();
    }

    public String getLoadString() {
        return this.ssProxy.getLoadString();
    }

    public int getCurrentGenerationNumber() {
        return this.ssProxy.getCurrentGenerationNumber();
    }

    public long getUptime() {
        return this.runtimeProxy.getUptime();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.memProxy.getHeapMemoryUsage();
    }

    public void takeSnapshot(String snapshotName) throws IOException {
        this.ssProxy.takeAllSnapshot(snapshotName);
    }

    public void clearSnapshot() throws IOException {
        this.ssProxy.clearSnapshot();
    }

    public void decommission() throws InterruptedException {
        this.ssProxy.decommission();
    }

    public void loadBalance() throws IOException, InterruptedException {
        this.ssProxy.loadBalance();
    }

    public void move(String newToken) throws IOException, InterruptedException {
        this.ssProxy.move(newToken);
    }

    public void removeToken(String token) {
        this.ssProxy.removeToken(token);
    }

    public Iterator<Map.Entry<String, IExecutorMBean>> getThreadPoolMBeanProxies() {
        try {
            return new ThreadPoolProxyMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public void getCompactionThreshold(PrintStream outs) {
        outs.println("Current compaction threshold: Min=" + this.mcmProxy.getMinimumCompactionThreshold() + ", Max=" + this.mcmProxy.getMaximumCompactionThreshold());
    }

    public void setCompactionThreshold(int minimumCompactionThreshold, int maximumCompactionThreshold) {
        this.mcmProxy.setMinimumCompactionThreshold(minimumCompactionThreshold);
        if (maximumCompactionThreshold >= 0) {
            this.mcmProxy.setMaximumCompactionThreshold(maximumCompactionThreshold);
        }
    }

    public void setCacheCapacities(String tableName, String cfName, int keyCacheCapacity, int rowCacheCapacity) {
        try {
            String keyCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "KeyCache";
            JMXInstrumentedCacheMBean keyCacheMBean = JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(keyCachePath), JMXInstrumentedCacheMBean.class);
            keyCacheMBean.setCapacity(keyCacheCapacity);
            String rowCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "RowCache";
            JMXInstrumentedCacheMBean rowCacheMBean = null;
            rowCacheMBean = JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(rowCachePath), JMXInstrumentedCacheMBean.class);
            rowCacheMBean.setCapacity(rowCacheCapacity);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InetAddress> getEndPoints(String keyspace, String key) {
        return this.ssProxy.getNaturalEndpoints(keyspace, key);
    }

    public Set<InetAddress> getStreamDestinations() {
        return this.streamProxy.getStreamDestinations();
    }

    public List<String> getFilesDestinedFor(InetAddress host) throws IOException {
        return this.streamProxy.getOutgoingFiles(host.getHostAddress());
    }

    public Set<InetAddress> getStreamSources() {
        return this.streamProxy.getStreamSources();
    }

    public List<String> getIncomingFiles(InetAddress host) throws IOException {
        return this.streamProxy.getIncomingFiles(host.getHostAddress());
    }

    public String getOperationMode() {
        return this.ssProxy.getOperationMode();
    }
}

