/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class SSTableImport {
    private static final String KEYSPACE_OPTION = "K";
    private static final String COLFAM_OPTION = "c";
    private static Options options = new Options();
    private static CommandLine cmd;

    private static void addToStandardCF(JSONArray row, ColumnFamily cfamily) {
        for (Object c : row) {
            JsonColumn col = new JsonColumn(c);
            QueryPath path = new QueryPath(cfamily.name(), null, FBUtilities.hexToBytes(col.name));
            cfamily.addColumn(path, FBUtilities.hexToBytes(col.value), col.timestamp, col.isDeleted);
        }
    }

    private static void addToSuperCF(JSONObject row, ColumnFamily cfamily) {
        for (Map.Entry entry : row.entrySet()) {
            byte[] superName = FBUtilities.hexToBytes((String)entry.getKey());
            long deletedAt = (Long)((JSONObject)entry.getValue()).get((Object)"deletedAt");
            JSONArray subColumns = (JSONArray)((JSONObject)entry.getValue()).get((Object)"subColumns");
            for (Object c : subColumns) {
                JsonColumn col = new JsonColumn(c);
                QueryPath path = new QueryPath(cfamily.name(), superName, FBUtilities.hexToBytes(col.name));
                cfamily.addColumn(path, FBUtilities.hexToBytes(col.value), col.timestamp, col.isDeleted);
            }
            SuperColumn superColumn = (SuperColumn)cfamily.getColumn(superName);
            superColumn.markForDeleteAt((int)(System.currentTimeMillis() / 1000L), deletedAt);
        }
    }

    public static void importJson(String jsonFile, String keyspace, String cf, String ssTablePath) throws IOException, org.json.simple.parser.ParseException {
        ColumnFamily cfamily = ColumnFamily.create(keyspace, cf);
        String cfType = cfamily.type();
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            JSONObject json = (JSONObject)JSONValue.parseWithException((Reader)new FileReader(jsonFile));
            SSTableWriter writer = new SSTableWriter(ssTablePath, json.size(), partitioner);
            ArrayList decoratedKeys = new ArrayList();
            for (String string : json.keySet()) {
                decoratedKeys.add(partitioner.decorateKey(string));
            }
            Collections.sort(decoratedKeys);
            for (DecoratedKey decoratedKey : decoratedKeys) {
                if (cfType.equals("Super")) {
                    SSTableImport.addToSuperCF((JSONObject)json.get((Object)decoratedKey.key), cfamily);
                } else {
                    SSTableImport.addToStandardCF((JSONArray)json.get((Object)decoratedKey.key), cfamily);
                }
                ColumnFamily.serializer().serializeWithIndexes(cfamily, dob);
                writer.append(decoratedKey, dob);
                dob.reset();
                cfamily.clear();
            }
            writer.closeAndOpenReader();
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Invalid JSON input, or incorrect column family.", cce);
        }
    }

    public static void main(String[] args) throws IOException, org.json.simple.parser.ParseException {
        String usage = String.format("Usage: %s -K keyspace -c column_family <json> <sstable>%n", SSTableImport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 2) {
            System.err.println(usage);
            System.exit(1);
        }
        String json = cmd.getArgs()[0];
        String ssTable = cmd.getArgs()[1];
        String keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
        String cfamily = cmd.getOptionValue(COLFAM_OPTION);
        SSTableImport.importJson(json, keyspace, cfamily, ssTable);
        System.exit(0);
    }

    static {
        Option optKeyspace = new Option(KEYSPACE_OPTION, true, "Keyspace name");
        optKeyspace.setRequired(true);
        options.addOption(optKeyspace);
        Option optColfamily = new Option(COLFAM_OPTION, true, "Column family");
        optColfamily.setRequired(true);
        options.addOption(optColfamily);
    }

    private static class JsonColumn {
        private String name;
        private String value;
        private long timestamp;
        private boolean isDeleted;

        private JsonColumn(Object obj) throws ClassCastException {
            JSONArray colSpec = (JSONArray)obj;
            assert (colSpec.size() == 4);
            this.name = (String)colSpec.get(0);
            this.value = (String)colSpec.get(1);
            this.timestamp = (Long)colSpec.get(2);
            this.isDeleted = (Boolean)colSpec.get(3);
        }
    }
}

