/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.BitSet;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.BloomCalculations;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.Filter;
import org.apache.log4j.Logger;

public class BloomFilter
extends Filter {
    private static final Logger logger = Logger.getLogger(BloomFilter.class);
    static ICompactSerializer<BloomFilter> serializer_ = new BloomFilterSerializer();
    private static final int EXCESS = 20;
    private BitSet filter_;

    public static ICompactSerializer<BloomFilter> serializer() {
        return serializer_;
    }

    BloomFilter(int hashes, BitSet filter) {
        this.hashCount = hashes;
        this.filter_ = filter;
    }

    private static BitSet bucketsFor(long numElements, int bucketsPer) {
        long numBits = numElements * (long)bucketsPer + 20L;
        return new BitSet((int)Math.min(Integer.MAX_VALUE, numBits));
    }

    private static int maxBucketsPerElement(long numElements) {
        double v = 2.147483627E9 / (double)(numElements = Math.max(1L, numElements));
        if (v < 1.0) {
            throw new UnsupportedOperationException("Cannot compute probabilities for " + numElements + " elements.");
        }
        return Math.min(BloomCalculations.probs.length - 1, (int)v);
    }

    public static BloomFilter getFilter(long numElements, int targetBucketsPerElem) {
        int maxBucketsPerElement = Math.max(1, BloomFilter.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn((Object)String.format("Cannot provide an optimal BloomFilter for %d elements (%d/%d buckets per element).", numElements, bucketsPerElement, targetBucketsPerElem));
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return new BloomFilter(spec.K, BloomFilter.bucketsFor(numElements, spec.bucketsPerElement));
    }

    public static BloomFilter getFilter(long numElements, double maxFalsePosProbability) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        int bucketsPerElement = BloomFilter.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return new BloomFilter(spec.K, BloomFilter.bucketsFor(numElements, spec.bucketsPerElement));
    }

    public void clear() {
        this.filter_.clear();
    }

    @Override
    int buckets() {
        return this.filter_.size();
    }

    BitSet filter() {
        return this.filter_;
    }

    @Override
    public boolean isPresent(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public boolean isPresent(byte[] key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public void add(byte[] key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public String toString() {
        return this.filter_.toString();
    }

    ICompactSerializer tserializer() {
        return serializer_;
    }

    @Override
    int emptyBuckets() {
        int n = 0;
        for (int i = 0; i < this.buckets(); ++i) {
            if (this.filter_.get(i)) continue;
            ++n;
        }
        return n;
    }

    public static BloomFilter alwaysMatchingBloomFilter() {
        BitSet set = new BitSet(64);
        set.set(0, 64);
        return new BloomFilter(1, set);
    }
}

