/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.cassandra.cache.ICacheExpungeHook;
import org.apache.log4j.Logger;

public class ExpiringMap<K, V> {
    private ICacheExpungeHook<K, V> globalHook_;
    private Hashtable<K, CacheableObject> cache_;
    private Map<K, ICacheExpungeHook<K, V>> hooks_;
    private Timer timer_;
    private static int counter_ = 0;
    private static final Logger LOGGER = Logger.getLogger(ExpiringMap.class);

    private void init(long expiration) {
        if (expiration <= 0L) {
            throw new IllegalArgumentException("Argument specified must be a positive number");
        }
        this.cache_ = new Hashtable();
        this.hooks_ = new Hashtable<K, ICacheExpungeHook<K, V>>();
        this.timer_ = new Timer("CACHETABLE-TIMER-" + ++counter_, true);
        this.timer_.schedule((TimerTask)new CacheMonitor(expiration), expiration, expiration);
    }

    public ExpiringMap(long expiration) {
        this.init(expiration);
    }

    public ExpiringMap(long expiration, ICacheExpungeHook<K, V> global) {
        this.init(expiration);
        this.globalHook_ = global;
    }

    public void shutdown() {
        this.timer_.cancel();
    }

    public void put(K key, V value) {
        this.cache_.put(key, new CacheableObject(value));
    }

    public void put(K key, V value, ICacheExpungeHook<K, V> hook) {
        this.put(key, value);
        this.hooks_.put(key, hook);
    }

    public V get(K key) {
        V result = null;
        CacheableObject co = this.cache_.get(key);
        if (co != null) {
            result = co.getValue();
        }
        return result;
    }

    public V remove(K key) {
        CacheableObject co = this.cache_.remove(key);
        V result = null;
        if (co != null) {
            result = co.getValue();
        }
        return result;
    }

    public int size() {
        return this.cache_.size();
    }

    public boolean containsKey(K key) {
        return this.cache_.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.cache_.containsValue(new CacheableObject(value));
    }

    public boolean isEmpty() {
        return this.cache_.isEmpty();
    }

    public Set<K> keySet() {
        return this.cache_.keySet();
    }

    private class CacheMonitor
    extends TimerTask {
        private long expiration_;

        CacheMonitor(long expiration) {
            this.expiration_ = expiration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object key;
            HashMap expungedValues = new HashMap();
            Hashtable hashtable = ExpiringMap.this.cache_;
            synchronized (hashtable) {
                Enumeration e = ExpiringMap.this.cache_.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    CacheableObject co = (CacheableObject)ExpiringMap.this.cache_.get(key);
                    if (co == null || !co.isReadyToDie(this.expiration_)) continue;
                    Object v = co.getValue();
                    if (null != v) {
                        expungedValues.put(key, v);
                    }
                    ExpiringMap.this.cache_.remove(key);
                }
            }
            for (Map.Entry entry : expungedValues.entrySet()) {
                key = entry.getKey();
                Object value = entry.getValue();
                ICacheExpungeHook hook = (ICacheExpungeHook)ExpiringMap.this.hooks_.remove(key);
                if (hook != null) {
                    hook.callMe(key, value);
                    continue;
                }
                if (ExpiringMap.this.globalHook_ == null) continue;
                ExpiringMap.this.globalHook_.callMe(key, value);
            }
            expungedValues.clear();
        }
    }

    private class CacheableObject {
        private V value_;
        private long age_;

        CacheableObject(V o) {
            this.value_ = o;
            this.age_ = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            return this.value_.equals(o);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        V getValue() {
            return this.value_;
        }

        boolean isReadyToDie(long expiration) {
            return System.currentTimeMillis() - this.age_ > expiration;
        }
    }
}

