/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class FBUtilities {
    private static Logger logger_ = Logger.getLogger(FBUtilities.class);
    public static final BigInteger TWO = new BigInteger("2");
    private static volatile InetAddress localInetAddress_;

    public static String[] strip(String string, String token) {
        StringTokenizer st = new StringTokenizer(string, token);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add((String)st.nextElement());
        }
        return result.toArray(new String[0]);
    }

    public static double parseDoubleOrPercent(String value) {
        if (value.endsWith("%")) {
            return Double.valueOf(value.substring(0, value.length() - 1)) / 100.0;
        }
        return Double.valueOf(value);
    }

    public static InetAddress getLocalAddress() {
        if (localInetAddress_ == null) {
            try {
                localInetAddress_ = DatabaseDescriptor.getListenAddress() == null ? InetAddress.getLocalHost() : DatabaseDescriptor.getListenAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localInetAddress_;
    }

    public static long absoluteFromFraction(double fractOrAbs, long total) {
        if (fractOrAbs < 0.0) {
            throw new UnsupportedOperationException("unexpected negative value " + fractOrAbs);
        }
        if (0.0 < fractOrAbs && fractOrAbs < 1.0) {
            return Math.max(1L, (long)(fractOrAbs * (double)total));
        }
        assert (fractOrAbs >= 1.0 || fractOrAbs == 0.0);
        return (long)fractOrAbs;
    }

    public static Pair<BigInteger, Boolean> midpoint(BigInteger left, BigInteger right, int sigbits) {
        BigInteger midpoint;
        boolean remainder;
        if (left.compareTo(right) < 0) {
            BigInteger sum = left.add(right);
            remainder = sum.testBit(0);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger max = TWO.pow(sigbits);
            BigInteger distance = max.add(right).subtract(left);
            remainder = distance.testBit(0);
            midpoint = distance.shiftRight(1).add(left).mod(max);
        }
        return new Pair<BigInteger, Boolean>(midpoint, remainder);
    }

    public static byte[] toByteArray(int i) {
        byte[] bytes = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return bytes;
    }

    public static int byteArrayToInt(byte[] bytes) {
        return FBUtilities.byteArrayToInt(bytes, 0);
    }

    public static int byteArrayToInt(byte[] bytes, int offset) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("An integer must be 4 bytes in size.");
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n <<= 8;
            n |= bytes[offset + i] & 0xFF;
        }
        return n;
    }

    public static int compareByteArrays(byte[] bytes1, byte[] bytes2) {
        if (null == bytes1) {
            if (null == bytes2) {
                return 0;
            }
            return -1;
        }
        if (null == bytes2) {
            return 1;
        }
        int minLength = Math.min(bytes1.length, bytes2.length);
        for (int i = 0; i < minLength; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return (bytes1[i] & 0xFF) < (bytes2[i] & 0xFF) ? -1 : 1;
        }
        if (bytes1.length == bytes2.length) {
            return 0;
        }
        return bytes1.length < bytes2.length ? -1 : 1;
    }

    public static byte[] xor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.length > right.length) {
            byte[] swap = left;
            left = right;
            right = swap;
        }
        byte[] out = Arrays.copyOf(right, right.length);
        for (int i = 0; i < left.length; ++i) {
            out[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
        return out;
    }

    public static BigInteger hash(String data) {
        byte[] result = FBUtilities.hash("MD5", new byte[][]{data.getBytes()});
        BigInteger hash = new BigInteger(result);
        return hash.abs();
    }

    public static byte[] hash(String type, byte[] ... data) {
        byte[] result = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(type);
            for (byte[] block : data) {
                messageDigest.update(block);
            }
            result = messageDigest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static void compressToStream(byte[] input, ByteArrayOutputStream bos) throws IOException {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
    }

    public static byte[] decompress(byte[] compressedData, int off, int len) throws IOException, DataFormatException {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData, off, len);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            int count = decompressor.inflate(buf);
            bos.write(buf, 0, count);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static void writeByteArray(byte[] bytes, DataOutput out) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static byte[] hexToBytes(String str) {
        assert (str.length() % 2 == 0);
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
        }
        return bytes;
    }

    public static String bytesToHex(byte ... bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int bint = b & 0xFF;
            if (bint <= 15) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(bint));
        }
        return sb.toString();
    }

    public static String mapToString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        return sb.append("}").toString();
    }

    public static void writeNullableString(String key, DataOutput dos) throws IOException {
        dos.writeBoolean(key == null);
        if (key != null) {
            dos.writeUTF(key);
        }
    }

    public static String readNullableString(DataInput dis) throws IOException {
        if (dis.readBoolean()) {
            return null;
        }
        return dis.readUTF();
    }

    public static void renameWithConfirm(String tmpFilename, String filename) throws IOException {
        if (!new File(tmpFilename).renameTo(new File(filename))) {
            throw new IOException("rename failed of " + filename);
        }
    }

    public static <T extends Comparable<T>> CollatingIterator getCollatingIterator() {
        return new CollatingIterator(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        });
    }

    public static void atomicSetMax(AtomicInteger atomic, int i) {
        int j;
        while ((j = atomic.getAndSet(i)) > i) {
            i = j;
        }
    }

    public static void atomicSetMax(AtomicLong atomic, long i) {
        long j;
        while ((j = atomic.getAndSet(i)) > i) {
            i = j;
        }
    }

    public static void serialize(TSerializer serializer, TBase struct, DataOutput out) throws IOException {
        byte[] bytes;
        assert (serializer != null);
        assert (struct != null);
        assert (out != null);
        try {
            bytes = serializer.serialize(struct);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static void deserialize(TDeserializer deserializer, TBase struct, DataInput in) throws IOException {
        assert (deserializer != null);
        assert (struct != null);
        assert (in != null);
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        try {
            deserializer.deserialize(struct, bytes);
        }
        catch (TException ex) {
            throw new IOException(ex);
        }
    }

    public static void sortSampledKeys(List<DecoratedKey> keys, Range range) {
        if (range.left.compareTo(range.right) >= 0) {
            final Token right = range.right;
            Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

                @Override
                public int compare(DecoratedKey o1, DecoratedKey o2) {
                    if (right.compareTo(o1.token) < 0 && right.compareTo(o2.token) < 0 || right.compareTo(o1.token) > 0 && right.compareTo(o2.token) > 0) {
                        return o1.compareTo(o2);
                    }
                    return -o1.compareTo(o2);
                }
            };
            Collections.sort(keys, comparator);
        } else {
            Collections.sort(keys);
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b == null) {
            return false;
        }
        if (a == null && b != null) {
            return false;
        }
        return a.equals(b);
    }

    public static int encodedUTF8Length(String st) {
        int strlen = st.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }
}

