/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.atomic.AtomicLong;

public class LatencyTracker {
    private final AtomicLong opCount = new AtomicLong(0L);
    private final AtomicLong totalLatency = new AtomicLong(0L);
    private long lastLatency = 0L;
    private long lastOpCount = 0L;

    public void addNano(long nanos) {
        this.addMicro(nanos / 1000L);
    }

    public void addMicro(long micros) {
        this.opCount.incrementAndGet();
        this.totalLatency.addAndGet(micros);
    }

    public long getOpCount() {
        return this.opCount.get();
    }

    public long getTotalLatencyMicros() {
        return this.totalLatency.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRecentLatencyMicros() {
        long ops = this.opCount.get();
        long n = this.totalLatency.get();
        try {
            double d = ((double)n - (double)this.lastLatency) / (double)(ops - this.lastOpCount);
            return d;
        }
        finally {
            this.lastLatency = n;
            this.lastOpCount = ops;
        }
    }
}

