/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtils {
    private Document document_;
    private XPath xpath_;

    public XMLUtils(String xmlSrc) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        File xmlFile = new File(xmlSrc);
        this.document_ = db.parse(xmlFile);
        XPathFactory xpathFactory = XPathFactory.newInstance();
        this.xpath_ = xpathFactory.newXPath();
    }

    public String getNodeValue(String xql) throws XPathExpressionException {
        String value = this.xpath_.compile(xql).evaluate(this.document_);
        return "".equals(value) ? null : value;
    }

    public String[] getNodeValues(String xql) throws XPathExpressionException {
        XPathExpression expr = this.xpath_.compile(xql);
        NodeList nl = (NodeList)expr.evaluate(this.document_, XPathConstants.NODESET);
        int size = nl.getLength();
        String[] values = new String[size];
        for (int i = 0; i < size; ++i) {
            Node node = nl.item(i);
            node = node.getFirstChild();
            values[i] = node.getNodeValue();
        }
        return values;
    }

    public NodeList getRequestedNodeList(String xql) throws XPathExpressionException {
        XPathExpression expr = this.xpath_.compile(xql);
        NodeList nodeList = (NodeList)expr.evaluate(this.document_, XPathConstants.NODESET);
        return nodeList;
    }

    public static String getAttributeValue(Node node, String attrName) throws TransformerException {
        String value = null;
        if ((node = node.getAttributes().getNamedItem(attrName)) != null) {
            value = node.getNodeValue();
        }
        return value;
    }

    public static void main(String[] args) throws Throwable {
        XMLUtils xmlUtils = new XMLUtils("C:\\Engagements\\Cassandra-Golden\\storage-conf.xml");
        String[] value = xmlUtils.getNodeValues("/Storage/Seeds/Seed");
        System.out.println(value);
    }
}

