/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cli;

import org.apache.cassandra.cli.CliSessionState;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CliOptions {
    private static Options options = null;
    private static final String HOST_OPTION = "host";
    private static final String PORT_OPTION = "port";
    private static final String UNFRAME_OPTION = "unframed";
    private static final String DEBUG_OPTION = "debug";
    private static final String USERNAME_OPTION = "username";
    private static final String PASSWORD_OPTION = "password";
    private static final String KEYSPACE_OPTION = "keyspace";
    private static final String BATCH_OPTION = "batch";
    private static final String HELP_OPTION = "help";
    private static final String FILE_OPTION = "file";
    private static final int DEFAULT_THRIFT_PORT = 9160;

    private static void printUsage() {
        System.err.println("Usage: cassandra-cli --host hostname [--port <portname>] [--file <filename>] [--unframed] [--debug]");
        System.err.println("\t[--username username] [--password password] [--keyspace keyspace] [--batch] [--help]");
    }

    public void processArgs(CliSessionState css, String[] args) {
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            css.hostName = !cmd.hasOption(HOST_OPTION) ? null : cmd.getOptionValue(HOST_OPTION);
            if (cmd.hasOption(UNFRAME_OPTION)) {
                css.framed = false;
            }
            if (cmd.hasOption(DEBUG_OPTION)) {
                css.debug = true;
            }
            css.thriftPort = cmd.hasOption(PORT_OPTION) ? Integer.parseInt(cmd.getOptionValue(PORT_OPTION)) : 9160;
            if (cmd.hasOption(USERNAME_OPTION)) {
                css.username = cmd.getOptionValue(USERNAME_OPTION);
            }
            if (cmd.hasOption(PASSWORD_OPTION)) {
                css.password = cmd.getOptionValue(PASSWORD_OPTION);
            }
            if (cmd.hasOption(KEYSPACE_OPTION)) {
                css.keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
            }
            if (cmd.hasOption(BATCH_OPTION)) {
                css.batch = true;
            }
            if (cmd.hasOption(FILE_OPTION)) {
                css.filename = cmd.getOptionValue(FILE_OPTION);
            }
            if (cmd.hasOption(HELP_OPTION)) {
                CliOptions.printUsage();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            CliOptions.printUsage();
            System.err.println("\n" + e.getMessage());
            System.exit(1);
        }
    }

    static {
        options = new Options();
        options.addOption(HOST_OPTION, true, "cassandra server's host name");
        options.addOption(PORT_OPTION, true, "cassandra server's thrift port");
        options.addOption(UNFRAME_OPTION, false, "cassandra server's framed transport");
        options.addOption(DEBUG_OPTION, false, "display stack traces");
        options.addOption(USERNAME_OPTION, true, "username for cassandra authentication");
        options.addOption(PASSWORD_OPTION, true, "password for cassandra authentication");
        options.addOption(KEYSPACE_OPTION, true, "cassandra keyspace user is authenticated against");
        options.addOption(BATCH_OPTION, false, "enabled batch mode (supress output; errors are fatal)");
        options.addOption(FILE_OPTION, true, "load statements from the specific file.");
        options.addOption(HELP_OPTION, false, "usage help.");
    }
}

