/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.CfDef;
import org.apache.cassandra.avro.KsDef;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.io.SerDeUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.commons.lang.ObjectUtils;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> strategyClass;
    public final Map<String, String> strategyOptions;
    public final int replicationFactor;
    private final Map<String, CFMetaData> cfMetaData;

    public KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, int replicationFactor, CFMetaData ... cfDefs) {
        this.name = name;
        this.strategyClass = strategyClass == null ? SimpleStrategy.class : strategyClass;
        this.strategyOptions = strategyOptions;
        this.replicationFactor = replicationFactor;
        HashMap<String, CFMetaData> cfmap = new HashMap<String, CFMetaData>();
        for (CFMetaData cfm : cfDefs) {
            cfmap.put(cfm.cfName, cfm);
        }
        this.cfMetaData = Collections.unmodifiableMap(cfmap);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)obj;
        return other.name.equals(this.name) && ObjectUtils.equals(other.strategyClass, this.strategyClass) && ObjectUtils.equals(other.strategyOptions, this.strategyOptions) && other.replicationFactor == this.replicationFactor && other.cfMetaData.size() == this.cfMetaData.size() && ((Object)other.cfMetaData).equals(this.cfMetaData);
    }

    public Map<String, CFMetaData> cfMetaData() {
        return this.cfMetaData;
    }

    public KsDef deflate() {
        KsDef ks = new KsDef();
        ks.name = new Utf8(this.name);
        ks.strategy_class = new Utf8(this.strategyClass.getName());
        if (this.strategyOptions != null) {
            ks.strategy_options = new HashMap<CharSequence, CharSequence>();
            for (Map.Entry<String, String> e : this.strategyOptions.entrySet()) {
                ks.strategy_options.put((CharSequence)new Utf8(e.getKey()), (CharSequence)new Utf8(e.getValue()));
            }
        }
        ks.replication_factor = this.replicationFactor;
        ks.cf_defs = SerDeUtils.createArray(this.cfMetaData.size(), CfDef.SCHEMA$);
        for (CFMetaData cfm : this.cfMetaData.values()) {
            ks.cf_defs.add(cfm.deflate());
        }
        return ks;
    }

    public static KSMetaData inflate(KsDef ks) {
        Class<?> repStratClass;
        try {
            String strategyClassName = KSMetaData.convertOldStrategyName(((Object)ks.strategy_class).toString());
            repStratClass = Class.forName(strategyClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create ReplicationStrategy of type " + ks.strategy_class, ex);
        }
        HashMap<String, String> strategyOptions = null;
        if (ks.strategy_options != null) {
            strategyOptions = new HashMap<String, String>();
            for (Map.Entry<CharSequence, CharSequence> e : ks.strategy_options.entrySet()) {
                strategyOptions.put(((Object)e.getKey()).toString(), ((Object)e.getValue()).toString());
            }
        }
        int cfsz = ks.cf_defs.size();
        CFMetaData[] cfMetaData = new CFMetaData[cfsz];
        Iterator<CfDef> cfiter = ks.cf_defs.iterator();
        for (int i = 0; i < cfsz; ++i) {
            cfMetaData[i] = CFMetaData.inflate(cfiter.next());
        }
        return new KSMetaData(((Object)ks.name).toString(), repStratClass, strategyOptions, ks.replication_factor, cfMetaData);
    }

    public static String convertOldStrategyName(String name) {
        return name.replace("RackUnawareStrategy", "SimpleStrategy").replace("RackAwareStrategy", "OldNetworkTopologyStrategy");
    }
}

